package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * It represents the response for a data ingestion.
 */
@Builder
@Schema(name = "OutputIngestDataDto",
        title = "Data ingestion response",
        description = "Represents the response for Data ingestion operation")
@Data
public class OutputIngestDataDto {
    private final int totalCount;
    private final int successfulCount;
    private final int failedCount;
    private final List<String> errors;
}
