/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.finconsgroup.itserr.marketplace.core.web.dto.PutIdParameterBody;
import com.finconsgroup.itserr.marketplace.search.dm.dto.ExpertiseDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.LocationDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.ReferencesDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.UserProfileCvDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.UserProfileProjectDto;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.time.Instant;
import java.util.List;
import lombok.Generated;

@Schema(title="Create/Update User Profile search document DTO", description="Represents the payload to create/update a User Profile search document")
public class InputUserProfileDto
implements PutIdParameterBody {
    @Schema(description="ID", example="123e4567-e89b-12d3-a456-426614174000")
    @NotBlank
    private String id;
    @Schema(description="First Name", example="John")
    private String firstName;
    @Schema(description="Last Name", example="Doe")
    private String lastName;
    @Schema(description="Email address of the user", example="john.doe@example.com")
    private String email;
    @Schema(description="Folder Id of the User Profile", example="550e8400-e29b-41d4-a716-446655440000")
    private String userProfileFolderId;
    @Schema(description="Link of the image of user", example="https://imageLink")
    private String imageUrl;
    @Schema(description="Flag to indicate if user exists", example="true")
    private Boolean userExists;
    @Schema(description="Projects")
    private List<UserProfileProjectDto> projects;
    @Schema(description="CV details of the user")
    private UserProfileCvDto cv;
    @Schema(description="ORCID identifier of the user", example="0000-0002-1825-0097")
    private String orcid;
    @Schema(description="Whether the user is open to collaboration", example="false")
    private Boolean openToCollaboration;
    @Schema(description="Whether the user's email is publicly visible", example="true")
    private boolean showPublicEmail;
    @Schema(description="Personal website URL", example="https://johndoe.example.com")
    private String personalWebsite;
    @Schema(description="LinkedIn profile URL", example="https://linkedin.com/in/johndoe")
    private String linkedinProfile;
    @Schema(description="Social profile URL (e.g., GitHub)", example="https://github.com/johndoe")
    private String socialProfile;
    @Schema(description="Short biography of the user", example="Ricercatore Legge 210/10 a tempo indeterminato")
    private String shortBio;
    @Schema(description="User's working location details")
    private LocationDto workingLocation;
    @Schema(description="Organization affiliation", example="Stanford University")
    private String organizationAffiliation;
    @Schema(description="Scientific Disciplinary Sectors", example="[\"INF/01\", \"ING-INF/05\"]")
    private List<String> ssd;
    @Schema(description="Areas of Expertise")
    private List<ExpertiseDto> expertises;
    @Schema(description="References")
    private ReferencesDto references;
    @Schema(description="User preferred language")
    private String language;
    @Schema(description="Whether the user profile is private or public", example="false")
    private boolean publicProfile;
    @Schema(description=" thematic interests of user", example="[\"Physics\", \"Maths\"]")
    private List<String> interests;
    @Schema(description="The creation time of the table record", example="2025-04-06T10:15:30Z")
    private Instant creationTime;
    @Schema(description="The last update time of the table record", example="2025-04-06T10:15:30Z")
    private Instant updateTime;

    @JsonIgnore
    @Hidden
    public String getPutId() {
        return this.id;
    }

    @Generated
    InputUserProfileDto(String id, String firstName, String lastName, String email, String userProfileFolderId, String imageUrl, Boolean userExists, List<UserProfileProjectDto> projects, UserProfileCvDto cv, String orcid, Boolean openToCollaboration, boolean showPublicEmail, String personalWebsite, String linkedinProfile, String socialProfile, String shortBio, LocationDto workingLocation, String organizationAffiliation, List<String> ssd, List<ExpertiseDto> expertises, ReferencesDto references, String language, boolean publicProfile, List<String> interests, Instant creationTime, Instant updateTime) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.userProfileFolderId = userProfileFolderId;
        this.imageUrl = imageUrl;
        this.userExists = userExists;
        this.projects = projects;
        this.cv = cv;
        this.orcid = orcid;
        this.openToCollaboration = openToCollaboration;
        this.showPublicEmail = showPublicEmail;
        this.personalWebsite = personalWebsite;
        this.linkedinProfile = linkedinProfile;
        this.socialProfile = socialProfile;
        this.shortBio = shortBio;
        this.workingLocation = workingLocation;
        this.organizationAffiliation = organizationAffiliation;
        this.ssd = ssd;
        this.expertises = expertises;
        this.references = references;
        this.language = language;
        this.publicProfile = publicProfile;
        this.interests = interests;
        this.creationTime = creationTime;
        this.updateTime = updateTime;
    }

    @Generated
    public static InputUserProfileDtoBuilder builder() {
        return new InputUserProfileDtoBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getUserProfileFolderId() {
        return this.userProfileFolderId;
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public Boolean getUserExists() {
        return this.userExists;
    }

    @Generated
    public List<UserProfileProjectDto> getProjects() {
        return this.projects;
    }

    @Generated
    public UserProfileCvDto getCv() {
        return this.cv;
    }

    @Generated
    public String getOrcid() {
        return this.orcid;
    }

    @Generated
    public Boolean getOpenToCollaboration() {
        return this.openToCollaboration;
    }

    @Generated
    public boolean isShowPublicEmail() {
        return this.showPublicEmail;
    }

    @Generated
    public String getPersonalWebsite() {
        return this.personalWebsite;
    }

    @Generated
    public String getLinkedinProfile() {
        return this.linkedinProfile;
    }

    @Generated
    public String getSocialProfile() {
        return this.socialProfile;
    }

    @Generated
    public String getShortBio() {
        return this.shortBio;
    }

    @Generated
    public LocationDto getWorkingLocation() {
        return this.workingLocation;
    }

    @Generated
    public String getOrganizationAffiliation() {
        return this.organizationAffiliation;
    }

    @Generated
    public List<String> getSsd() {
        return this.ssd;
    }

    @Generated
    public List<ExpertiseDto> getExpertises() {
        return this.expertises;
    }

    @Generated
    public ReferencesDto getReferences() {
        return this.references;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public boolean isPublicProfile() {
        return this.publicProfile;
    }

    @Generated
    public List<String> getInterests() {
        return this.interests;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setUserProfileFolderId(String userProfileFolderId) {
        this.userProfileFolderId = userProfileFolderId;
    }

    @Generated
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Generated
    public void setUserExists(Boolean userExists) {
        this.userExists = userExists;
    }

    @Generated
    public void setProjects(List<UserProfileProjectDto> projects) {
        this.projects = projects;
    }

    @Generated
    public void setCv(UserProfileCvDto cv) {
        this.cv = cv;
    }

    @Generated
    public void setOrcid(String orcid) {
        this.orcid = orcid;
    }

    @Generated
    public void setOpenToCollaboration(Boolean openToCollaboration) {
        this.openToCollaboration = openToCollaboration;
    }

    @Generated
    public void setShowPublicEmail(boolean showPublicEmail) {
        this.showPublicEmail = showPublicEmail;
    }

    @Generated
    public void setPersonalWebsite(String personalWebsite) {
        this.personalWebsite = personalWebsite;
    }

    @Generated
    public void setLinkedinProfile(String linkedinProfile) {
        this.linkedinProfile = linkedinProfile;
    }

    @Generated
    public void setSocialProfile(String socialProfile) {
        this.socialProfile = socialProfile;
    }

    @Generated
    public void setShortBio(String shortBio) {
        this.shortBio = shortBio;
    }

    @Generated
    public void setWorkingLocation(LocationDto workingLocation) {
        this.workingLocation = workingLocation;
    }

    @Generated
    public void setOrganizationAffiliation(String organizationAffiliation) {
        this.organizationAffiliation = organizationAffiliation;
    }

    @Generated
    public void setSsd(List<String> ssd) {
        this.ssd = ssd;
    }

    @Generated
    public void setExpertises(List<ExpertiseDto> expertises) {
        this.expertises = expertises;
    }

    @Generated
    public void setReferences(ReferencesDto references) {
        this.references = references;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public void setPublicProfile(boolean publicProfile) {
        this.publicProfile = publicProfile;
    }

    @Generated
    public void setInterests(List<String> interests) {
        this.interests = interests;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputUserProfileDto)) {
            return false;
        }
        InputUserProfileDto other = (InputUserProfileDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isShowPublicEmail() != other.isShowPublicEmail()) {
            return false;
        }
        if (this.isPublicProfile() != other.isPublicProfile()) {
            return false;
        }
        Boolean this$userExists = this.getUserExists();
        Boolean other$userExists = other.getUserExists();
        if (this$userExists == null ? other$userExists != null : !((Object)this$userExists).equals(other$userExists)) {
            return false;
        }
        Boolean this$openToCollaboration = this.getOpenToCollaboration();
        Boolean other$openToCollaboration = other.getOpenToCollaboration();
        if (this$openToCollaboration == null ? other$openToCollaboration != null : !((Object)this$openToCollaboration).equals(other$openToCollaboration)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$userProfileFolderId = this.getUserProfileFolderId();
        String other$userProfileFolderId = other.getUserProfileFolderId();
        if (this$userProfileFolderId == null ? other$userProfileFolderId != null : !this$userProfileFolderId.equals(other$userProfileFolderId)) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
            return false;
        }
        List this$projects = this.getProjects();
        List other$projects = other.getProjects();
        if (this$projects == null ? other$projects != null : !((Object)this$projects).equals(other$projects)) {
            return false;
        }
        UserProfileCvDto this$cv = this.getCv();
        UserProfileCvDto other$cv = other.getCv();
        if (this$cv == null ? other$cv != null : !this$cv.equals(other$cv)) {
            return false;
        }
        String this$orcid = this.getOrcid();
        String other$orcid = other.getOrcid();
        if (this$orcid == null ? other$orcid != null : !this$orcid.equals(other$orcid)) {
            return false;
        }
        String this$personalWebsite = this.getPersonalWebsite();
        String other$personalWebsite = other.getPersonalWebsite();
        if (this$personalWebsite == null ? other$personalWebsite != null : !this$personalWebsite.equals(other$personalWebsite)) {
            return false;
        }
        String this$linkedinProfile = this.getLinkedinProfile();
        String other$linkedinProfile = other.getLinkedinProfile();
        if (this$linkedinProfile == null ? other$linkedinProfile != null : !this$linkedinProfile.equals(other$linkedinProfile)) {
            return false;
        }
        String this$socialProfile = this.getSocialProfile();
        String other$socialProfile = other.getSocialProfile();
        if (this$socialProfile == null ? other$socialProfile != null : !this$socialProfile.equals(other$socialProfile)) {
            return false;
        }
        String this$shortBio = this.getShortBio();
        String other$shortBio = other.getShortBio();
        if (this$shortBio == null ? other$shortBio != null : !this$shortBio.equals(other$shortBio)) {
            return false;
        }
        LocationDto this$workingLocation = this.getWorkingLocation();
        LocationDto other$workingLocation = other.getWorkingLocation();
        if (this$workingLocation == null ? other$workingLocation != null : !this$workingLocation.equals(other$workingLocation)) {
            return false;
        }
        String this$organizationAffiliation = this.getOrganizationAffiliation();
        String other$organizationAffiliation = other.getOrganizationAffiliation();
        if (this$organizationAffiliation == null ? other$organizationAffiliation != null : !this$organizationAffiliation.equals(other$organizationAffiliation)) {
            return false;
        }
        List this$ssd = this.getSsd();
        List other$ssd = other.getSsd();
        if (this$ssd == null ? other$ssd != null : !((Object)this$ssd).equals(other$ssd)) {
            return false;
        }
        List this$expertises = this.getExpertises();
        List other$expertises = other.getExpertises();
        if (this$expertises == null ? other$expertises != null : !((Object)this$expertises).equals(other$expertises)) {
            return false;
        }
        ReferencesDto this$references = this.getReferences();
        ReferencesDto other$references = other.getReferences();
        if (this$references == null ? other$references != null : !this$references.equals(other$references)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        List this$interests = this.getInterests();
        List other$interests = other.getInterests();
        if (this$interests == null ? other$interests != null : !((Object)this$interests).equals(other$interests)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputUserProfileDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShowPublicEmail() ? 79 : 97);
        result = result * 59 + (this.isPublicProfile() ? 79 : 97);
        Boolean $userExists = this.getUserExists();
        result = result * 59 + ($userExists == null ? 43 : ((Object)$userExists).hashCode());
        Boolean $openToCollaboration = this.getOpenToCollaboration();
        result = result * 59 + ($openToCollaboration == null ? 43 : ((Object)$openToCollaboration).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $userProfileFolderId = this.getUserProfileFolderId();
        result = result * 59 + ($userProfileFolderId == null ? 43 : $userProfileFolderId.hashCode());
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        List $projects = this.getProjects();
        result = result * 59 + ($projects == null ? 43 : ((Object)$projects).hashCode());
        UserProfileCvDto $cv = this.getCv();
        result = result * 59 + ($cv == null ? 43 : $cv.hashCode());
        String $orcid = this.getOrcid();
        result = result * 59 + ($orcid == null ? 43 : $orcid.hashCode());
        String $personalWebsite = this.getPersonalWebsite();
        result = result * 59 + ($personalWebsite == null ? 43 : $personalWebsite.hashCode());
        String $linkedinProfile = this.getLinkedinProfile();
        result = result * 59 + ($linkedinProfile == null ? 43 : $linkedinProfile.hashCode());
        String $socialProfile = this.getSocialProfile();
        result = result * 59 + ($socialProfile == null ? 43 : $socialProfile.hashCode());
        String $shortBio = this.getShortBio();
        result = result * 59 + ($shortBio == null ? 43 : $shortBio.hashCode());
        LocationDto $workingLocation = this.getWorkingLocation();
        result = result * 59 + ($workingLocation == null ? 43 : $workingLocation.hashCode());
        String $organizationAffiliation = this.getOrganizationAffiliation();
        result = result * 59 + ($organizationAffiliation == null ? 43 : $organizationAffiliation.hashCode());
        List $ssd = this.getSsd();
        result = result * 59 + ($ssd == null ? 43 : ((Object)$ssd).hashCode());
        List $expertises = this.getExpertises();
        result = result * 59 + ($expertises == null ? 43 : ((Object)$expertises).hashCode());
        ReferencesDto $references = this.getReferences();
        result = result * 59 + ($references == null ? 43 : $references.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        List $interests = this.getInterests();
        result = result * 59 + ($interests == null ? 43 : ((Object)$interests).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InputUserProfileDto(id=" + this.getId() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", email=" + this.getEmail() + ", userProfileFolderId=" + this.getUserProfileFolderId() + ", imageUrl=" + this.getImageUrl() + ", userExists=" + this.getUserExists() + ", projects=" + String.valueOf(this.getProjects()) + ", cv=" + String.valueOf(this.getCv()) + ", orcid=" + this.getOrcid() + ", openToCollaboration=" + this.getOpenToCollaboration() + ", showPublicEmail=" + this.isShowPublicEmail() + ", personalWebsite=" + this.getPersonalWebsite() + ", linkedinProfile=" + this.getLinkedinProfile() + ", socialProfile=" + this.getSocialProfile() + ", shortBio=" + this.getShortBio() + ", workingLocation=" + String.valueOf(this.getWorkingLocation()) + ", organizationAffiliation=" + this.getOrganizationAffiliation() + ", ssd=" + String.valueOf(this.getSsd()) + ", expertises=" + String.valueOf(this.getExpertises()) + ", references=" + String.valueOf(this.getReferences()) + ", language=" + this.getLanguage() + ", publicProfile=" + this.isPublicProfile() + ", interests=" + String.valueOf(this.getInterests()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ")";
    }
}

