package com.finconsgroup.itserr.marketplace.search.dm.mapper;

import com.finconsgroup.itserr.marketplace.search.dm.dto.InputEventDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputEventLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Event;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

/**
 * Mapper for all dto/entity conversions related to {@link Event}
 */
@Mapper(config = MapperConfiguration.class, uses = {UserProfileMapper.class})
public interface EventMapper {

    @Mapping(target = "score", ignore = true)
    Event toEntity(InputEventDto dto);

    OutputEventDto toDto(Event entity);

    OutputGlobalSearchAutoCompleteDataDto toAutoCompleteDataDto(Event entity);

    OutputEventLocalSearchDto toLocalSearchDto(Event entity);

    @Mapping(target = "description", source = "content")
    @Mapping(target = "imageUrl", source = "image.url")
    OutputGlobalSearchDataDto toGlobalSearchDataDto(Event entity);

}
