/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.bs.messaging;

import com.finconsgroup.itserr.marketplace.search.bs.client.dm.SearchDmClient;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.MessagingDiscussionBsProperties;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.SearchBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.search.bs.messaging.AbstractResourceSubscriber;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="discussionResourceSubscriber")
public class DiscussionResourceSubscriber
extends AbstractResourceSubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiscussionResourceSubscriber.class);
    private final MessagingDiscussionBsProperties messagingDiscussionBsProperties;
    private final SearchDmClient searchDmClient;

    public DiscussionResourceSubscriber(SearchBsConfigurationProperties searchBsConfigurationProperties, SearchDmClient searchDmClient) {
        this.messagingDiscussionBsProperties = searchBsConfigurationProperties.getMessaging().getDiscussionBs();
        this.searchDmClient = searchDmClient;
    }

    protected void handleResource(String resourceId, Object resourcePayload, String eventType) {
        log.debug("Processing discussion bs event, id: {}, payload: {}, type: {}", new Object[]{resourceId, resourcePayload, eventType});
        if (Objects.equals(eventType, this.messagingDiscussionBsProperties.getResourceCreatedEventType()) || Objects.equals(eventType, this.messagingDiscussionBsProperties.getResourceUpdatedEventType())) {
            this.searchDmClient.upsertDiscussion(resourceId, resourcePayload);
        } else if (Objects.equals(eventType, this.messagingDiscussionBsProperties.getResourceDeletedEventType())) {
            this.searchDmClient.deleteDiscussion(resourceId);
        } else {
            log.error("Unsupported eventType: {} for resourceId: {}", (Object)eventType, (Object)resourceId);
        }
    }
}

