/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.bs.messaging;

import com.finconsgroup.itserr.marketplace.search.bs.client.dm.SearchDmClient;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.MessagingUserProfileBsProperties;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.SearchBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.search.bs.messaging.AbstractResourceSubscriber;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="userProfileResourceSubscriber")
public class UserProfileResourceSubscriber
extends AbstractResourceSubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserProfileResourceSubscriber.class);
    private final MessagingUserProfileBsProperties messagingUserProfileBsProperties;
    private final SearchDmClient searchDmClient;

    public UserProfileResourceSubscriber(SearchBsConfigurationProperties searchBsConfigurationProperties, SearchDmClient searchDmClient) {
        this.messagingUserProfileBsProperties = searchBsConfigurationProperties.getMessaging().getUserProfileBs();
        this.searchDmClient = searchDmClient;
    }

    protected void handleResource(String resourceId, Object resourcePayload, String eventType) {
        log.debug("Processing user profile event: id: {}, payload: {}, type: {}", new Object[]{eventType, resourceId, resourcePayload});
        if (Objects.equals(eventType, this.messagingUserProfileBsProperties.getResourceCreatedEventType()) || Objects.equals(eventType, this.messagingUserProfileBsProperties.getResourceUpdatedEventType())) {
            this.searchDmClient.upsertUserProfile(resourceId, resourcePayload);
        } else if (Objects.equals(eventType, this.messagingUserProfileBsProperties.getResourceDeletedEventType())) {
            this.searchDmClient.deleteUserProfile(resourceId);
        } else {
            log.error("Unsupported eventType: {} for resourceId: {}", (Object)eventType, (Object)resourceId);
        }
    }
}

