package com.finconsgroup.itserr.marketplace.search.bs.config.properties;

import jakarta.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class MessagingNewsBsProperties {

    /**
     * Bean name of the consumer handler.
     */
    @NotBlank
    private String consumerHandlerBeanName;

    /**
     * Event type string used for resource creation events.
     */
    @NotBlank
    private String resourceCreatedEventType;

    /**
     * Event type string used for resource update events.
     */
    @NotBlank
    private String resourceUpdatedEventType;

    /**
     * Event type string used for resource deletion events.
     */
    @NotBlank
    private String resourceDeletedEventType;

}
