package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event;

import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.filter.ConsumerHandlerFilterRegistry;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

/**
 * Factory class responsible for creating {@link StreamMultiplexerConsumerMessageHandler} instances for processing messages from specific streams.
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class StreamMultiplexerConsumerMessageHandlerFactory {

    /** Registry for managing and applying filters on consumer handlers when processing messages. */
    private final ConsumerHandlerFilterRegistry handlersFilterRegistry;

    /**
     * Creates a new {@link StreamMultiplexerConsumerMessageHandler} for the specified stream.
     *
     * @param stream the stream identifier for which to create the handler
     * @return a new {@link StreamMultiplexerConsumerMessageHandler} instance
     */
    @NonNull
    public StreamMultiplexerConsumerMessageHandler create(
            @NonNull final String stream) {
        return new StreamMultiplexerConsumerMessageHandler(stream, handlersFilterRegistry);
    }

}
