package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.filter;

import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.NotificationConsumerMessageHandler;
import io.cloudevents.CloudEvent;
import lombok.RequiredArgsConstructor;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * Registry that manages filters for notification consumer message handlers. This class determines whether a handler should process a specific CloudEvent by
 * applying all registered filters.
 */
@Component
@RequiredArgsConstructor
public class ConsumerHandlerFilterRegistry {

    /** List of filters to be applied when checking handler support for events */
    private final List<ConsumerHandlerFilter> filters;

    /**
     * Determines if a given handler should process the specified {@link CloudEvent} according to all filters. The handler should satisfy all filters to be
     * considered supporting the event.
     *
     * @param handler the notification consumer message handler to check
     * @param event the cloud event to be processed
     * @return true if the handler should process the event, false otherwise
     */
    public boolean supports(
            @NonNull final NotificationConsumerMessageHandler handler,
            @NonNull final CloudEvent event) {
        return filters.stream()
                .allMatch(filter -> filter.supports(handler, event));
    }

}
