package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.client.NotificationBsClient;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.config.properties.BusNotificationProperties;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.extractor.FieldExtractorRegistry;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

/**
 * Factory class responsible for creating {@link JsonNotificationConsumerMessageHandler} instances to handle bus notification messages in JSON format.
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class JsonNotificationConsumerMessageHandlerFactory {

    /** Instance of {@link ObjectMapper} used for JSON serialization and deserialization. */
    private final ObjectMapper objectMapper;

    /** Registry for fields extraction. */
    private final FieldExtractorRegistry fieldExtractorRegistry;

    /** Client used for communication with the Notification BS microservice. */
    private final NotificationBsClient notificationBsClient;

    /**
     * Creates a new {@link JsonNotificationConsumerMessageHandler} instance with the specified name and configuration.
     *
     * @param name the name identifier for the handler
     * @param config the bus notification configuration properties
     * @return a new {@link JsonNotificationConsumerMessageHandler} instance
     */
    @NonNull
    public JsonNotificationConsumerMessageHandler create(
            @NonNull final String name,
            @NonNull final BusNotificationProperties config) {
        return new JsonNotificationConsumerMessageHandler(
                name,
                config,
                objectMapper,
                fieldExtractorRegistry,
                notificationBsClient);
    }

}
