package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.config.properties;

import jakarta.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;
import org.springframework.validation.annotation.Validated;

/**
 * Configuration properties class for bus notification settings that extends base notification properties.
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Validated
public class BusNotificationProperties extends NotificationProperties {

    /** The stream identifier for bus notifications */
    @NotBlank
    private String stream;

}
