package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.filter;

import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.NotificationConsumerMessageHandler;
import io.cloudevents.CloudEvent;
import org.springframework.lang.NonNull;

/**
 * A functional interface that defines a filter for notification consumer message handlers. Used to determine if a specific handler should process a given
 * {@link CloudEvent} according to the filter rule.
 */
@FunctionalInterface
public interface ConsumerHandlerFilter {

    /**
     * Determines if a given handler should process the specified {@link CloudEvent} according to the implemented filter.
     *
     * @param handler the notification consumer message handler to check
     * @param event the {@link CloudEvent} to be processed
     * @return true if the handler should process the event, false otherwise
     */
    boolean supports(
            @NonNull NotificationConsumerMessageHandler handler,
            @NonNull CloudEvent event);

}
