package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.extractor;

import org.springframework.lang.NonNull;

import java.util.List;

/**
 * <p>A functional interface representing a strategy for extracting a value from an object based on a specified field name.</p>
 *
 * <p>This interface is designed to enable flexible extraction logic, allowing various implementations to define how fields are retrieved from a given source
 * object. Implementations may provide support for extracting fields from different data structures, objects, or custom mappings.</p>
 */
@FunctionalInterface
public interface FieldExtractor {

    /**
     * Extracts a value from the specified source object based on the provided field name.
     *
     * @param field the name/pattern of the field that should be extracted
     * @param source the object from which the field value should be extracted
     * @return the list of extracted String values, or empty list if the field is not found
     * @throws UnsupportedOperationException when field format or source are not supported.
     */
    @NonNull
    List<String> extract(
            @NonNull String field,
            @NonNull Object source);

}
