/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.notification.dm.entity.UserNotificationEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import lombok.Generated;
import org.hibernate.annotations.JdbcTypeCode;

@Entity
@Table(name="user_notification")
public class UserNotificationEntity
extends AbstractUUIDEntity {
    @Column(name="user_ref", nullable=false)
    private String user;
    @Column(name="notification_type", nullable=false, length=100)
    private String type;
    @Column(name="referenced_id", nullable=false, length=100)
    private String referencedId;
    @Column(name="placeholder_values", nullable=false, columnDefinition="jsonb")
    @JdbcTypeCode(value=3001)
    private Map<String, String> placeholderValues;
    @Column(name="is_read")
    private Boolean read;
    @Column(name="is_archived")
    private Boolean archived;
    @Column(name="last_read_time")
    private ZonedDateTime lastReadTime;
    @Column(name="creation_time", nullable=false)
    private ZonedDateTime creationTime;
    @Column(name="update_time", nullable=false)
    private ZonedDateTime updateTime;
    @Version
    @Column(name="version", nullable=false)
    private long version;

    public void prePersist() {
        super.prePersist();
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
    }

    @Generated
    protected UserNotificationEntity(UserNotificationEntityBuilder<?, ?> b) {
        super(b);
        this.user = b.user;
        this.type = b.type;
        this.referencedId = b.referencedId;
        this.placeholderValues = b.placeholderValues;
        this.read = b.read;
        this.archived = b.archived;
        this.lastReadTime = b.lastReadTime;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
    }

    @Generated
    public static UserNotificationEntityBuilder<?, ?> builder() {
        return new UserNotificationEntityBuilderImpl();
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getReferencedId() {
        return this.referencedId;
    }

    @Generated
    public Map<String, String> getPlaceholderValues() {
        return this.placeholderValues;
    }

    @Generated
    public Boolean getRead() {
        return this.read;
    }

    @Generated
    public Boolean getArchived() {
        return this.archived;
    }

    @Generated
    public ZonedDateTime getLastReadTime() {
        return this.lastReadTime;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setReferencedId(String referencedId) {
        this.referencedId = referencedId;
    }

    @Generated
    public void setPlaceholderValues(Map<String, String> placeholderValues) {
        this.placeholderValues = placeholderValues;
    }

    @Generated
    public void setRead(Boolean read) {
        this.read = read;
    }

    @Generated
    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    @Generated
    public void setLastReadTime(ZonedDateTime lastReadTime) {
        this.lastReadTime = lastReadTime;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(ZonedDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "UserNotificationEntity(user=" + this.getUser() + ", type=" + this.getType() + ", referencedId=" + this.getReferencedId() + ", placeholderValues=" + String.valueOf(this.getPlaceholderValues()) + ", read=" + this.getRead() + ", archived=" + this.getArchived() + ", lastReadTime=" + String.valueOf(this.getLastReadTime()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserNotificationEntity)) {
            return false;
        }
        UserNotificationEntity other = (UserNotificationEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Boolean this$read = this.getRead();
        Boolean other$read = other.getRead();
        if (this$read == null ? other$read != null : !((Object)this$read).equals(other$read)) {
            return false;
        }
        Boolean this$archived = this.getArchived();
        Boolean other$archived = other.getArchived();
        if (this$archived == null ? other$archived != null : !((Object)this$archived).equals(other$archived)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$referencedId = this.getReferencedId();
        String other$referencedId = other.getReferencedId();
        if (this$referencedId == null ? other$referencedId != null : !this$referencedId.equals(other$referencedId)) {
            return false;
        }
        Map this$placeholderValues = this.getPlaceholderValues();
        Map other$placeholderValues = other.getPlaceholderValues();
        if (this$placeholderValues == null ? other$placeholderValues != null : !((Object)this$placeholderValues).equals(other$placeholderValues)) {
            return false;
        }
        ZonedDateTime this$lastReadTime = this.getLastReadTime();
        ZonedDateTime other$lastReadTime = other.getLastReadTime();
        if (this$lastReadTime == null ? other$lastReadTime != null : !((Object)this$lastReadTime).equals(other$lastReadTime)) {
            return false;
        }
        ZonedDateTime this$creationTime = this.getCreationTime();
        ZonedDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserNotificationEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        Boolean $read = this.getRead();
        result = result * 59 + ($read == null ? 43 : ((Object)$read).hashCode());
        Boolean $archived = this.getArchived();
        result = result * 59 + ($archived == null ? 43 : ((Object)$archived).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $referencedId = this.getReferencedId();
        result = result * 59 + ($referencedId == null ? 43 : $referencedId.hashCode());
        Map $placeholderValues = this.getPlaceholderValues();
        result = result * 59 + ($placeholderValues == null ? 43 : ((Object)$placeholderValues).hashCode());
        ZonedDateTime $lastReadTime = this.getLastReadTime();
        result = result * 59 + ($lastReadTime == null ? 43 : ((Object)$lastReadTime).hashCode());
        ZonedDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public UserNotificationEntity() {
    }
}

