/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.dm.dto;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import java.util.UUID;
import org.springframework.lang.NonNull;

public record UserDto(@NonNull UUID id, @NonNull String username, @NonNull String email) {
    @NonNull
    private final UUID id;
    @NonNull
    private final String username;
    @NonNull
    private final String email;

    public UserDto(@NonNull UUID id, @NonNull String username, @NonNull String email) {
        this.id = id;
        this.username = username;
        this.email = email;
    }

    public static UserDto fromSecurityOrThrow() {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        String userUsername = JwtTokenHolder.getPreferredUsernameOrThrow();
        String userEmail = JwtTokenHolder.getEmailOrThrow();
        return new UserDto(userId, userUsername, userEmail);
    }

    @NonNull
    public UUID id() {
        return this.id;
    }

    @NonNull
    public String username() {
        return this.username;
    }

    @NonNull
    public String email() {
        return this.email;
    }
}

