package com.finconsgroup.itserr.marketplace.notification.dm.controller;

import com.finconsgroup.itserr.marketplace.notification.dm.api.UserNotificationInternalApi;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputLocalizedUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.service.LocalizedUserNotificationService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * REST controller class for handling user Notification related API requests.
 *
 * <p>Implements the {@link UserNotificationInternalApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class UserNotificationInternalController implements UserNotificationInternalApi {

    private final LocalizedUserNotificationService localizedUserNotificationService;

    @Override
    public OutputLocalizedUserNotificationDto findById(
            final UUID notificationId,
            final String acceptLanguage) {
        return localizedUserNotificationService.findById(notificationId, acceptLanguage);
    }

}
