/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.dm.service.impl;

import com.finconsgroup.itserr.marketplace.notification.dm.configuration.property.TemplateCacheConfigurationProperties;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputNotificationEmailTemplateDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputNotificationTemplateDto;
import com.finconsgroup.itserr.marketplace.notification.dm.mapper.NotificationEmailTemplateMapper;
import com.finconsgroup.itserr.marketplace.notification.dm.mapper.NotificationTemplateMapper;
import com.finconsgroup.itserr.marketplace.notification.dm.repository.NotificationEmailTemplateRepository;
import com.finconsgroup.itserr.marketplace.notification.dm.repository.NotificationTemplateRepository;
import com.finconsgroup.itserr.marketplace.notification.dm.service.NotificationTemplateService;
import com.finconsgroup.itserr.marketplace.notification.dm.service.impl.DefaultNotificationTemplateService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class DefaultNotificationTemplateService
implements NotificationTemplateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultNotificationTemplateService.class);
    private final TemplateCacheConfigurationProperties cacheConfig;
    private final NotificationTemplateRepository notificationTemplateRepository;
    private final NotificationTemplateMapper notificationTemplateMapper;
    private final NotificationEmailTemplateRepository notificationEmailTemplateRepository;
    private final NotificationEmailTemplateMapper notificationEmailTemplateMapper;
    private final Map<TemplateId, OutputNotificationTemplateDto> templateCache = new HashMap();
    private Long templateCacheLastLoad = null;
    private final Map<String, OutputNotificationEmailTemplateDto> emailTemplateCache = new HashMap();
    private Long emailTemplateCacheLastLoad = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNotificationTemplates() {
        log.debug("Loading notification templates from database");
        List templates = this.notificationTemplateRepository.findAll();
        Map map = this.templateCache;
        synchronized (map) {
            this.templateCache.clear();
            templates.forEach(t -> this.templateCache.put(new TemplateId(t.getNotificationType(), t.getLanguageCode()), this.notificationTemplateMapper.toDto(t)));
        }
        this.templateCacheLastLoad = System.currentTimeMillis();
        log.debug("Notification templates loaded successfully");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Optional<OutputNotificationTemplateDto> findByTypeAndLanguage(@NonNull String notificationType, @NonNull String languageCode) {
        TemplateId templateId = new TemplateId(notificationType, languageCode);
        Integer cacheTimeoutSec = this.cacheConfig.getTimeout();
        Map map = this.templateCache;
        synchronized (map) {
            this.inValidateCache();
            return Optional.ofNullable((OutputNotificationTemplateDto)this.templateCache.get(templateId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<OutputNotificationTemplateDto> findByType(@NonNull String notificationType) {
        Map map = this.templateCache;
        synchronized (map) {
            this.inValidateCache();
        }
        return this.templateCache.entrySet().stream().filter(entry -> notificationType.equals(((TemplateId)entry.getKey()).type())).map(Map.Entry::getValue).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<OutputNotificationEmailTemplateDto> findAllEmailTemplates() {
        Map map = this.emailTemplateCache;
        synchronized (map) {
            this.inValidateEmailCache();
        }
        return this.emailTemplateCache.values().stream().toList();
    }

    private void inValidateCache() {
        Integer cacheTimeoutSec = this.cacheConfig.getTimeout();
        if (this.templateCacheLastLoad == null || cacheTimeoutSec == null || System.currentTimeMillis() - this.templateCacheLastLoad > (long)(cacheTimeoutSec * 1000)) {
            log.debug("Notification templates cache is expired");
            this.loadNotificationTemplates();
        }
    }

    private void inValidateEmailCache() {
        Integer cacheTimeoutSec = this.cacheConfig.getTimeout();
        if (this.emailTemplateCacheLastLoad == null || cacheTimeoutSec == null || System.currentTimeMillis() - this.emailTemplateCacheLastLoad > (long)(cacheTimeoutSec * 1000)) {
            log.debug("Notification email templates cache is expired");
            this.loadNotificationEmailTemplates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNotificationEmailTemplates() {
        log.debug("Loading notification email templates from database");
        List emailTemplates = this.notificationEmailTemplateRepository.findAll();
        Map map = this.emailTemplateCache;
        synchronized (map) {
            this.emailTemplateCache.clear();
            emailTemplates.forEach(t -> this.emailTemplateCache.put(t.getLanguageCode(), this.notificationEmailTemplateMapper.toDto(t)));
        }
        this.emailTemplateCacheLastLoad = System.currentTimeMillis();
        log.debug("Notification email templates loaded successfully");
    }

    @Generated
    public DefaultNotificationTemplateService(TemplateCacheConfigurationProperties cacheConfig, NotificationTemplateRepository notificationTemplateRepository, NotificationTemplateMapper notificationTemplateMapper, NotificationEmailTemplateRepository notificationEmailTemplateRepository, NotificationEmailTemplateMapper notificationEmailTemplateMapper) {
        this.cacheConfig = cacheConfig;
        this.notificationTemplateRepository = notificationTemplateRepository;
        this.notificationTemplateMapper = notificationTemplateMapper;
        this.notificationEmailTemplateRepository = notificationEmailTemplateRepository;
        this.notificationEmailTemplateMapper = notificationEmailTemplateMapper;
    }
}

