package com.finconsgroup.itserr.marketplace.notification.dm;

import com.finconsgroup.itserr.marketplace.notification.dm.configuration.property.TemplateCacheConfigurationProperties;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Info;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.web.config.EnableSpringDataWebSupport;

@SpringBootApplication
@OpenAPIDefinition(info = @Info(
        title = "Notification DM API",
        description = "API definition of the Notification Microservice",
        version = "1.0.1"
))
@EnableConfigurationProperties({
        TemplateCacheConfigurationProperties.class,
})
@EnableSpringDataWebSupport(pageSerializationMode = EnableSpringDataWebSupport.PageSerializationMode.VIA_DTO)
public class NotificationDmApplication {

    public static void main(String[] args) {
        SpringApplication.run(NotificationDmApplication.class, args);
    }

}
