/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.dm.service.impl;

import com.finconsgroup.itserr.marketplace.notification.dm.service.LanguageService;
import com.finconsgroup.itserr.marketplace.notification.dm.service.impl.DefaultLanguageService;
import io.micrometer.common.util.StringUtils;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class DefaultLanguageService
implements LanguageService {
    private static final String DEFAULT_LANGUAGE = "en";

    public List<String> getPreferredLanguages(String httpAcceptLanguage) {
        LinkedHashSet<String> preferredLanguages = new LinkedHashSet<String>();
        if (httpAcceptLanguage != null) {
            preferredLanguages.addAll(this.parseAcceptLanguageHeader(httpAcceptLanguage));
        }
        preferredLanguages.add(DEFAULT_LANGUAGE);
        return preferredLanguages.stream().toList();
    }

    private List<String> parseAcceptLanguageHeader(String langHeader) {
        return Arrays.stream(langHeader.split(",")).map(arg_0 -> this.parseAcceptLanguageHeaderComponent(arg_0)).filter(Objects::nonNull).sorted((l1, l2) -> -Double.compare(l1.priority, l2.priority)).map(l -> l.code).toList();
    }

    private Language parseAcceptLanguageHeaderComponent(String s) {
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        String[] parts = s.split(";");
        String languageCode = parts[0];
        double priority = 1.0;
        for (int i = 1; i < parts.length; ++i) {
            if (!parts[i].startsWith("q=")) continue;
            try {
                priority = Double.parseDouble(parts[i].split("=")[1]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Language(languageCode, priority);
    }

    @Generated
    public DefaultLanguageService() {
    }
}

