package com.finconsgroup.itserr.marketplace.notification.dm.mapper;

import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputNotificationTemplateDto;
import com.finconsgroup.itserr.marketplace.notification.dm.entity.NotificationTemplateEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

/**
 * Mapper interface for converting between {@link NotificationTemplateEntity} and {@link OutputNotificationTemplateDto}.
 */
@Mapper(config = MapperConfiguration.class)
public interface NotificationTemplateMapper {

    /**
     * Converts a {@link NotificationTemplateEntity} to {@link OutputNotificationTemplateDto}.
     *
     * @param entity the notification template entity to convert
     * @return the converted output notification template DTO
     */
    @Mapping(target = "type", source = "notificationType")
    OutputNotificationTemplateDto toDto(NotificationTemplateEntity entity);

}
