package com.finconsgroup.itserr.marketplace.notification.dm.api;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputLocalizedUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputUserNotificationDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.ResponseStatus;

import java.util.UUID;

/**
 * This interface defines the contract for REST API endpoints related to Notification Management (internal use only).
 *
 * <p>
 * It provides endpoints for retrieving Notifications.
 * </p>
 *
 * <p>Example usage:
 * <pre>
 * GET  notification/internal/notifications/{id} - Retrieve a notification by id with no authorization check.
 * </pre>
 * </p>
 */
@Tag(
        name = "UserNotificationInternalApi",
        description = "The UserNotificationInternalApi API: it provides managing notifications with no authorization restriction."
)
public interface UserNotificationInternalApi {

    /**
     * Retrieves a user notification by id.
     *
     * @param id the id of the notification to retrieve
     * @param acceptLanguage the language code for localization (e.g. "en-US")
     * @return the found {@link OutputUserNotificationDto} and HTTP status 200 (OK)
     */
    @Operation(
            summary = "find user notification by id",
            responses = {
                    @ApiResponse(responseCode = "200", description = "OK"),
                    @ApiResponse(responseCode = "404", description = "Not Found",
                            content = {
                                    @Content(
                                            mediaType = MediaType.APPLICATION_JSON_VALUE,
                                            schema = @Schema(implementation = ErrorResponseDto.class)
                                    )
                            }),
            }
    )
    @GetMapping(value = "/notification/internal/notifications/{id}", produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseStatus(HttpStatus.OK)
    OutputLocalizedUserNotificationDto findById(
            @PathVariable("id") UUID id,
            @RequestHeader(name = "Accept-Language", required = false) String acceptLanguage);

}
