/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.bs.client.dto;

import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputCreateUserNotificationDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@Schema(name="InputCreateUserNotificationDto", description="DTO for creating a user notification")
public class InputCreateUserNotificationDto {
    @Schema(description="The users receiving the notification, expressed as an id, a username or an email")
    @NotNull(message="required field")
    private @NotNull(message="required field") List<String> users;
    @Schema(description="The type of notification", example="catalog-item-event-created")
    @NotBlank(message="required field")
    @Size(max=100, message="field length must be between {min} and {max}")
    private @NotBlank(message="required field") @Size(max=100, message="field length must be between {min} and {max}") String type;
    @Schema(description="ID of the referenced entity", example="12345")
    @NotBlank(message="required field")
    @Size(max=100, message="field length must be between {min} and {max}")
    private @NotBlank(message="required field") @Size(max=100, message="field length must be between {min} and {max}") String referencedId;
    @Schema(description="Placeholder values for notification template")
    private Map<String, String> placeholderValues;

    @Generated
    public static InputCreateUserNotificationDtoBuilder builder() {
        return new InputCreateUserNotificationDtoBuilder();
    }

    @Generated
    public List<String> getUsers() {
        return this.users;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getReferencedId() {
        return this.referencedId;
    }

    @Generated
    public Map<String, String> getPlaceholderValues() {
        return this.placeholderValues;
    }

    @Generated
    public void setUsers(List<String> users) {
        this.users = users;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setReferencedId(String referencedId) {
        this.referencedId = referencedId;
    }

    @Generated
    public void setPlaceholderValues(Map<String, String> placeholderValues) {
        this.placeholderValues = placeholderValues;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputCreateUserNotificationDto)) {
            return false;
        }
        InputCreateUserNotificationDto other = (InputCreateUserNotificationDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$users = this.getUsers();
        List other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$referencedId = this.getReferencedId();
        String other$referencedId = other.getReferencedId();
        if (this$referencedId == null ? other$referencedId != null : !this$referencedId.equals(other$referencedId)) {
            return false;
        }
        Map this$placeholderValues = this.getPlaceholderValues();
        Map other$placeholderValues = other.getPlaceholderValues();
        return !(this$placeholderValues == null ? other$placeholderValues != null : !((Object)this$placeholderValues).equals(other$placeholderValues));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputCreateUserNotificationDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $referencedId = this.getReferencedId();
        result = result * 59 + ($referencedId == null ? 43 : $referencedId.hashCode());
        Map $placeholderValues = this.getPlaceholderValues();
        result = result * 59 + ($placeholderValues == null ? 43 : ((Object)$placeholderValues).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InputCreateUserNotificationDto(users=" + String.valueOf(this.getUsers()) + ", type=" + this.getType() + ", referencedId=" + this.getReferencedId() + ", placeholderValues=" + String.valueOf(this.getPlaceholderValues()) + ")";
    }

    @Generated
    public InputCreateUserNotificationDto(List<String> users, String type, String referencedId, Map<String, String> placeholderValues) {
        this.users = users;
        this.type = type;
        this.referencedId = referencedId;
        this.placeholderValues = placeholderValues;
    }
}

