package com.finconsgroup.itserr.marketplace.notification.bs.client;

import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputFindUserProfilesByTokenInfoDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputUserProfileDto;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * Client interface for retrieving user profiles from a dedicated User Profile service.
 */
public interface UserProfileDmClient {
    /**
     * Finds user profiles by a set of infos contained into the JWT token.
     *
     * @param dto contains the set of info to fetch (single request body)
     */
    @PostMapping("/profiles-by-token-infos")
    List<OutputUserProfileDto> findAllByTokenInfo(
            @RequestBody InputFindUserProfilesByTokenInfoDto dto
    );

}
