package com.finconsgroup.itserr.marketplace.notification.bs.client.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.time.ZonedDateTime;
import java.util.UUID;

/**
 * Output DTO representing a patch user notification.
 */
@Schema(name = "OutputPatchUserNotificationDto", description = "DTO representing a patch user notification in responses")
@Data
@Builder
@AllArgsConstructor
public class OutputPatchUserNotificationDto {

    @Schema(description = "Unique identifier of the user notification", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "Flag indicating whether the notification has been read")
    private Boolean read;

    @Schema(description = "Flag indicating whether the notification has been archived")
    private Boolean archived;

    @Schema(description = "The last read time of the user notification", example = "2025-04-06T10:15:30+01:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime lastReadTime;
}
