/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.bs.websocket;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthenticationException;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenVerifier;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Component
public class WsProtocolJwtInterceptor
implements HandshakeInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WsProtocolJwtInterceptor.class);
    private final JwtTokenVerifier jwtTokenVerifier;

    public boolean beforeHandshake(@NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response, @NonNull WebSocketHandler wsHandler, @NonNull Map<String, Object> attributes) throws Exception {
        String protocol = request.getHeaders().getFirst("Sec-WebSocket-Protocol");
        if (StringUtils.isNotBlank((CharSequence)protocol)) {
            String jwt;
            HashMap<String, String> protocolAttributes = new HashMap<String, String>();
            String[] tokens = StringUtils.split((String)protocol, (String)",");
            for (int i = 1; i < tokens.length; i += 2) {
                String key = StringUtils.lowerCase((String)StringUtils.trim((String)tokens[i - 1]));
                String value = StringUtils.trim((String)tokens[i]);
                if (!StringUtils.isNotBlank((CharSequence)key) || value == null) continue;
                protocolAttributes.put(key, value);
            }
            if (protocolAttributes.containsKey("jwt") && StringUtils.isNotBlank((CharSequence)(jwt = (String)protocolAttributes.get("jwt")))) {
                try {
                    JwtTokenHolder.setToken((String)jwt, (JwtTokenVerifier)this.jwtTokenVerifier);
                }
                catch (WP2AuthenticationException e) {
                    log.error("Error validating JWT token", (Throwable)e);
                    return false;
                }
                if (JwtTokenHolder.getUserId().isEmpty()) {
                    log.error("Authorization was unsuccessful");
                    return false;
                }
                response.getHeaders().add("Sec-WebSocket-Protocol", "jwt");
            }
        }
        return true;
    }

    public void afterHandshake(@NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response, @NonNull WebSocketHandler wsHandler, Exception exception) {
    }

    @Generated
    public WsProtocolJwtInterceptor(JwtTokenVerifier jwtTokenVerifier) {
        this.jwtTokenVerifier = jwtTokenVerifier;
    }
}

