/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ExecutionException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.notification.bs.client.NotificationDmClient;
import com.finconsgroup.itserr.marketplace.notification.bs.client.UserProfileDmClient;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputCreateUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputFindUserProfilesByTokenInfoDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputPatchUserNotificationsDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputNotificationTemplateDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.notification.bs.event.NotificationPublisher;
import com.finconsgroup.itserr.marketplace.notification.bs.mapper.NotificationMapper;
import com.finconsgroup.itserr.marketplace.notification.bs.service.UserNotificationService;
import com.finconsgroup.itserr.marketplace.notification.bs.service.impl.EmailService;
import feign.FeignException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DefaultUserNotificationService
implements UserNotificationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultUserNotificationService.class);
    private final NotificationDmClient notificationDmClient;
    private final NotificationMapper notificationMapper;
    private final NotificationPublisher notificationPublisher;
    private final UserProfileDmClient userProfileDmClient;
    private final EmailService emailService;

    @NotNull
    public List<OutputUserNotificationDto> create(@NotNull InputCreateUserNotificationDto request, String acceptLanguage) {
        List notifications;
        try {
            log.debug("Creating notification on bs service");
            notifications = this.notificationDmClient.create(request, acceptLanguage);
        }
        catch (Exception e) {
            throw new WP2ExecutionException((Throwable)e);
        }
        try {
            log.debug("Publishing notification on websockets");
            for (OutputUserNotificationDto notification : notifications) {
                this.notificationPublisher.publishCreated(this.notificationMapper.toEvent(notification));
            }
        }
        catch (Exception e) {
            log.error("Error publishing created notification for websocket handling", (Throwable)e);
        }
        log.info("send email procedure\n ================START================");
        List messageTemplates = this.notificationDmClient.getMessageTemplatesByType(request.getType());
        if (!CollectionUtils.isEmpty((Collection)messageTemplates)) {
            @NotNull Map<String, String> languageTemplateMap = messageTemplates.stream().filter(template -> template.getLanguageCode() != null && template.getText() != null).collect(Collectors.toMap(template -> template.getLanguageCode().toUpperCase(), OutputNotificationTemplateDto::getText));
            try {
                log.info("Collecting users details by mixed token info");
                InputFindUserProfilesByTokenInfoDto inputUserTokenInfoList = new InputFindUserProfilesByTokenInfoDto(notifications.stream().map(OutputUserNotificationDto::getUser).toList());
                List userProfiles = this.userProfileDmClient.findAllByTokenInfo(inputUserTokenInfoList);
                @NotNull Set<T> filteredUsers = userProfiles.stream().filter(OutputUserProfileDto::isEmailConsent).collect(Collectors.toSet());
                this.preparingAndSendingEmails(filteredUsers, languageTemplateMap, notifications);
                log.info("{} emails successfully sent", (Object)filteredUsers.size());
            }
            catch (Exception e) {
                log.error("Error while publishing emails", (Throwable)e);
            }
            log.info("send email procedure\n ================END================");
        }
        return notifications;
    }

    private void preparingAndSendingEmails(@NotNull Set<OutputUserProfileDto> usersWithEmailConsent, @NotNull Map<String, String> languageTemplateMap, List<OutputUserNotificationDto> notifications) {
        for (OutputUserNotificationDto notification : notifications) {
            try {
                Optional<OutputUserProfileDto> matchedUser = usersWithEmailConsent.stream().filter(user -> this.matchesUserIdentifier(user, notification.getUser())).findFirst();
                if (matchedUser.isEmpty()) {
                    log.warn("No user profile found for notification user identifier: {}", (Object)notification.getUser());
                    continue;
                }
                OutputUserProfileDto userProfile = matchedUser.get();
                String template = languageTemplateMap.get(userProfile.getLanguage().toUpperCase());
                if (template == null || template.isEmpty()) {
                    log.warn("No email template found for language: {}, user: {} , adding english language as default", (Object)userProfile.getLanguage(), (Object)userProfile.getEmail());
                    template = languageTemplateMap.get("EN");
                }
                String emailBody = this.replacePlaceholders(template, notification.getPlaceholderValues());
                String subject = this.extractSubjectFromNotificationType(notification.getType());
                boolean sent = this.emailService.sendEmail(userProfile.getEmail(), subject, emailBody);
                if (sent) {
                    log.info("Email notification sent successfully to: {} for type: {}", (Object)userProfile.getEmail(), (Object)notification.getType());
                    continue;
                }
                log.error("Failed to send email notification to: {} for type: {}", (Object)userProfile.getEmail(), (Object)notification.getType());
            }
            catch (Exception e) {
                log.error("Error processing notification for user: {}", (Object)notification.getUser(), (Object)e);
            }
        }
    }

    private boolean matchesUserIdentifier(OutputUserProfileDto user, String identifier) {
        try {
            UUID uuid = UUID.fromString(identifier);
            if (user.getId() != null && user.getId().equals(uuid)) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (user.getEmail() != null && user.getEmail().equalsIgnoreCase(identifier)) {
            return true;
        }
        return user.getPreferredUsername() != null && user.getPreferredUsername().equalsIgnoreCase(identifier);
    }

    private String replacePlaceholders(String template, Map<String, String> placeholders) {
        if (placeholders == null || placeholders.isEmpty()) {
            return template;
        }
        String result = template;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue() != null ? entry.getValue() : "";
            String patternString = "['\"]?\\{\\{" + Pattern.quote(key) + "\\}\\}['\"]?";
            Pattern pattern = Pattern.compile(patternString, 2);
            Matcher matcher = pattern.matcher(result);
            result = matcher.replaceAll(Matcher.quoteReplacement(value));
        }
        return result;
    }

    private String extractSubjectFromNotificationType(String notificationType) {
        if (notificationType == null || notificationType.isEmpty()) {
            return "Notification";
        }
        return Arrays.stream(notificationType.split("-")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    @NotNull
    public OutputPatchUserNotificationDto patchById(@NotNull UUID notificationId, @NotNull InputPatchUserNotificationDto inputPatchUserNotificationDto) {
        try {
            return this.notificationDmClient.patchById(notificationId, inputPatchUserNotificationDto);
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException(notificationId);
        }
        catch (Exception e) {
            throw new WP2ExecutionException((Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteById(@NotNull UUID notificationId) {
        try {
            this.notificationDmClient.deleteById(notificationId);
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException(notificationId);
        }
        catch (Exception e) {
            throw new WP2ExecutionException((Throwable)e);
        }
    }

    public void patchAll(@NonNull InputPatchUserNotificationsDto request) {
        try {
            this.notificationDmClient.patchAll(request);
        }
        catch (Exception e) {
            throw new WP2ExecutionException((Throwable)e);
        }
    }

    @Generated
    public DefaultUserNotificationService(NotificationDmClient notificationDmClient, NotificationMapper notificationMapper, NotificationPublisher notificationPublisher, UserProfileDmClient userProfileDmClient, EmailService emailService) {
        this.notificationDmClient = notificationDmClient;
        this.notificationMapper = notificationMapper;
        this.notificationPublisher = notificationPublisher;
        this.userProfileDmClient = userProfileDmClient;
        this.emailService = emailService;
    }
}

