package com.finconsgroup.itserr.marketplace.news.dm.mapper;

import com.finconsgroup.itserr.marketplace.news.dm.dto.InputAuthorDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.InputCreateNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.InputImageDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.InputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.InputUpdateNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.OutputAuthorDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.OutputImageDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.OutputNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.entity.AuthorEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.NewsEntity;
import com.finconsgroup.itserr.marketplace.news.dm.model.InstitutionalPageModel;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-02-09T13:55:15+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class NewsMapperImpl implements NewsMapper {

    @Autowired
    private AuthorMapper authorMapper;

    @Override
    public NewsEntity toEntity(InputCreateNewsDto inputCreateNewsDto) {
        if ( inputCreateNewsDto == null ) {
            return null;
        }

        NewsEntity.NewsEntityBuilder<?, ?> newsEntity = NewsEntity.builder();

        newsEntity.imageId( inputCreateNewsDtoImageId( inputCreateNewsDto ) );
        newsEntity.imageUrl( inputCreateNewsDtoImageUrl( inputCreateNewsDto ) );
        newsEntity.title( inputCreateNewsDto.getTitle() );
        newsEntity.newsType( inputCreateNewsDto.getNewsType() );
        newsEntity.content( inputCreateNewsDto.getContent() );
        List<String> list = inputCreateNewsDto.getTags();
        if ( list != null ) {
            newsEntity.tags( new ArrayList<String>( list ) );
        }
        newsEntity.institutionalPages( inputInstitutionalPageDtoListToInstitutionalPageModelList( inputCreateNewsDto.getInstitutionalPages() ) );
        List<String> list2 = inputCreateNewsDto.getRegisteredAuthorIds();
        if ( list2 != null ) {
            newsEntity.registeredAuthorIds( new ArrayList<String>( list2 ) );
        }
        newsEntity.unRegisteredAuthors( inputAuthorDtoListToAuthorEntityList( inputCreateNewsDto.getUnRegisteredAuthors() ) );

        NewsEntity newsEntityResult = newsEntity.build();

        setUnregisteredAuthors( newsEntityResult );

        return newsEntityResult;
    }

    @Override
    public OutputNewsDto toDto(NewsEntity newsEntity) {
        if ( newsEntity == null ) {
            return null;
        }

        OutputNewsDto.OutputNewsDtoBuilder outputNewsDto = OutputNewsDto.builder();

        outputNewsDto.image( newsEntityToOutputImageDto( newsEntity ) );
        List<String> list = newsEntity.getTags();
        if ( list != null ) {
            outputNewsDto.tags( new ArrayList<String>( list ) );
        }
        else {
            outputNewsDto.tags( java.util.Collections.emptyList() );
        }
        List<String> list1 = newsEntity.getRegisteredAuthorIds();
        if ( list1 != null ) {
            outputNewsDto.registeredAuthorIds( new ArrayList<String>( list1 ) );
        }
        else {
            outputNewsDto.registeredAuthorIds( java.util.Collections.emptyList() );
        }
        outputNewsDto.id( newsEntity.getId() );
        outputNewsDto.title( newsEntity.getTitle() );
        outputNewsDto.creatorId( newsEntity.getCreatorId() );
        outputNewsDto.newsType( newsEntity.getNewsType() );
        outputNewsDto.content( newsEntity.getContent() );
        outputNewsDto.institutionalPages( institutionalPageModelListToOutputInstitutionalPageDtoList( newsEntity.getInstitutionalPages() ) );
        outputNewsDto.unRegisteredAuthors( authorEntityListToOutputAuthorDtoList( newsEntity.getUnRegisteredAuthors() ) );
        outputNewsDto.creationTime( newsEntity.getCreationTime() );
        outputNewsDto.updateTime( newsEntity.getUpdateTime() );

        return outputNewsDto.build();
    }

    @Override
    public void updateEntity(InputUpdateNewsDto dto, NewsEntity entity) {
        if ( dto == null ) {
            return;
        }

        entity.setImageId( dtoImageId( dto ) );
        entity.setImageUrl( dtoImageUrl( dto ) );
        entity.setTitle( dto.getTitle() );
        entity.setNewsType( dto.getNewsType() );
        entity.setContent( dto.getContent() );
        if ( entity.getTags() != null ) {
            List<String> list = dto.getTags();
            if ( list != null ) {
                entity.getTags().clear();
                entity.getTags().addAll( list );
            }
            else {
                entity.setTags( null );
            }
        }
        else {
            List<String> list = dto.getTags();
            if ( list != null ) {
                entity.setTags( new ArrayList<String>( list ) );
            }
        }
        if ( entity.getInstitutionalPages() != null ) {
            List<InstitutionalPageModel> list1 = inputInstitutionalPageDtoListToInstitutionalPageModelList( dto.getInstitutionalPages() );
            if ( list1 != null ) {
                entity.getInstitutionalPages().clear();
                entity.getInstitutionalPages().addAll( list1 );
            }
            else {
                entity.setInstitutionalPages( null );
            }
        }
        else {
            List<InstitutionalPageModel> list1 = inputInstitutionalPageDtoListToInstitutionalPageModelList( dto.getInstitutionalPages() );
            if ( list1 != null ) {
                entity.setInstitutionalPages( list1 );
            }
        }
        if ( entity.getRegisteredAuthorIds() != null ) {
            List<String> list2 = dto.getRegisteredAuthorIds();
            if ( list2 != null ) {
                entity.getRegisteredAuthorIds().clear();
                entity.getRegisteredAuthorIds().addAll( list2 );
            }
            else {
                entity.setRegisteredAuthorIds( null );
            }
        }
        else {
            List<String> list2 = dto.getRegisteredAuthorIds();
            if ( list2 != null ) {
                entity.setRegisteredAuthorIds( new ArrayList<String>( list2 ) );
            }
        }
        if ( entity.getUnRegisteredAuthors() != null ) {
            List<AuthorEntity> list3 = inputAuthorDtoListToAuthorEntityList( dto.getUnRegisteredAuthors() );
            if ( list3 != null ) {
                entity.getUnRegisteredAuthors().clear();
                entity.getUnRegisteredAuthors().addAll( list3 );
            }
            else {
                entity.setUnRegisteredAuthors( null );
            }
        }
        else {
            List<AuthorEntity> list3 = inputAuthorDtoListToAuthorEntityList( dto.getUnRegisteredAuthors() );
            if ( list3 != null ) {
                entity.setUnRegisteredAuthors( list3 );
            }
        }

        setUnregisteredAuthors( entity );
    }

    private UUID inputCreateNewsDtoImageId(InputCreateNewsDto inputCreateNewsDto) {
        InputImageDto image = inputCreateNewsDto.getImage();
        if ( image == null ) {
            return null;
        }
        return image.getId();
    }

    private String inputCreateNewsDtoImageUrl(InputCreateNewsDto inputCreateNewsDto) {
        InputImageDto image = inputCreateNewsDto.getImage();
        if ( image == null ) {
            return null;
        }
        return image.getUrl();
    }

    protected InstitutionalPageModel inputInstitutionalPageDtoToInstitutionalPageModel(InputInstitutionalPageDto inputInstitutionalPageDto) {
        if ( inputInstitutionalPageDto == null ) {
            return null;
        }

        InstitutionalPageModel.InstitutionalPageModelBuilder institutionalPageModel = InstitutionalPageModel.builder();

        institutionalPageModel.id( inputInstitutionalPageDto.getId() );
        institutionalPageModel.name( inputInstitutionalPageDto.getName() );

        return institutionalPageModel.build();
    }

    protected List<InstitutionalPageModel> inputInstitutionalPageDtoListToInstitutionalPageModelList(List<InputInstitutionalPageDto> list) {
        if ( list == null ) {
            return null;
        }

        List<InstitutionalPageModel> list1 = new ArrayList<InstitutionalPageModel>( list.size() );
        for ( InputInstitutionalPageDto inputInstitutionalPageDto : list ) {
            list1.add( inputInstitutionalPageDtoToInstitutionalPageModel( inputInstitutionalPageDto ) );
        }

        return list1;
    }

    protected List<AuthorEntity> inputAuthorDtoListToAuthorEntityList(List<InputAuthorDto> list) {
        if ( list == null ) {
            return null;
        }

        List<AuthorEntity> list1 = new ArrayList<AuthorEntity>( list.size() );
        for ( InputAuthorDto inputAuthorDto : list ) {
            list1.add( authorMapper.toEntity( inputAuthorDto ) );
        }

        return list1;
    }

    protected OutputImageDto newsEntityToOutputImageDto(NewsEntity newsEntity) {
        if ( newsEntity == null ) {
            return null;
        }

        OutputImageDto.OutputImageDtoBuilder outputImageDto = OutputImageDto.builder();

        outputImageDto.id( newsEntity.getImageId() );
        outputImageDto.url( newsEntity.getImageUrl() );

        return outputImageDto.build();
    }

    protected OutputInstitutionalPageDto institutionalPageModelToOutputInstitutionalPageDto(InstitutionalPageModel institutionalPageModel) {
        if ( institutionalPageModel == null ) {
            return null;
        }

        OutputInstitutionalPageDto.OutputInstitutionalPageDtoBuilder outputInstitutionalPageDto = OutputInstitutionalPageDto.builder();

        outputInstitutionalPageDto.id( institutionalPageModel.getId() );
        outputInstitutionalPageDto.name( institutionalPageModel.getName() );

        return outputInstitutionalPageDto.build();
    }

    protected List<OutputInstitutionalPageDto> institutionalPageModelListToOutputInstitutionalPageDtoList(List<InstitutionalPageModel> list) {
        if ( list == null ) {
            return new ArrayList<OutputInstitutionalPageDto>();
        }

        List<OutputInstitutionalPageDto> list1 = new ArrayList<OutputInstitutionalPageDto>( list.size() );
        for ( InstitutionalPageModel institutionalPageModel : list ) {
            list1.add( institutionalPageModelToOutputInstitutionalPageDto( institutionalPageModel ) );
        }

        return list1;
    }

    protected List<OutputAuthorDto> authorEntityListToOutputAuthorDtoList(List<AuthorEntity> list) {
        if ( list == null ) {
            return new ArrayList<OutputAuthorDto>();
        }

        List<OutputAuthorDto> list1 = new ArrayList<OutputAuthorDto>( list.size() );
        for ( AuthorEntity authorEntity : list ) {
            list1.add( authorMapper.toDto( authorEntity ) );
        }

        return list1;
    }

    private UUID dtoImageId(InputUpdateNewsDto inputUpdateNewsDto) {
        InputImageDto image = inputUpdateNewsDto.getImage();
        if ( image == null ) {
            return null;
        }
        return image.getId();
    }

    private String dtoImageUrl(InputUpdateNewsDto inputUpdateNewsDto) {
        InputImageDto image = inputUpdateNewsDto.getImage();
        if ( image == null ) {
            return null;
        }
        return image.getUrl();
    }
}
