package com.finconsgroup.itserr.marketplace.news.dm.mapper;

import com.finconsgroup.itserr.marketplace.news.dm.entity.ArchivedAuthorEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.ArchivedNewsEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.AuthorEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.NewsEntity;
import com.finconsgroup.itserr.marketplace.news.dm.model.InstitutionalPageModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-02-09T13:55:15+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class ArchivedNewsMapperImpl implements ArchivedNewsMapper {

    @Autowired
    private ArchivedAuthorMapper archivedAuthorMapper;

    @Override
    public ArchivedNewsEntity toArchivedEntity(NewsEntity src) {
        if ( src == null ) {
            return null;
        }

        ArchivedNewsEntity.ArchivedNewsEntityBuilder<?, ?> archivedNewsEntity = ArchivedNewsEntity.builder();

        archivedNewsEntity.id( src.getId() );
        archivedNewsEntity.title( src.getTitle() );
        archivedNewsEntity.creatorId( src.getCreatorId() );
        archivedNewsEntity.newsType( src.getNewsType() );
        archivedNewsEntity.content( src.getContent() );
        List<String> list = src.getTags();
        if ( list != null ) {
            archivedNewsEntity.tags( new ArrayList<String>( list ) );
        }
        List<InstitutionalPageModel> list1 = src.getInstitutionalPages();
        if ( list1 != null ) {
            archivedNewsEntity.institutionalPages( new ArrayList<InstitutionalPageModel>( list1 ) );
        }
        archivedNewsEntity.imageId( src.getImageId() );
        archivedNewsEntity.imageUrl( src.getImageUrl() );
        List<String> list2 = src.getRegisteredAuthorIds();
        if ( list2 != null ) {
            archivedNewsEntity.registeredAuthorIds( new ArrayList<String>( list2 ) );
        }
        archivedNewsEntity.unRegisteredAuthors( authorEntityListToArchivedAuthorEntityList( src.getUnRegisteredAuthors() ) );
        archivedNewsEntity.creationTime( src.getCreationTime() );
        archivedNewsEntity.updateTime( src.getUpdateTime() );
        archivedNewsEntity.version( src.getVersion() );

        ArchivedNewsEntity archivedNewsEntityResult = archivedNewsEntity.build();

        setUnregisteredAuthors( archivedNewsEntityResult );

        return archivedNewsEntityResult;
    }

    protected List<ArchivedAuthorEntity> authorEntityListToArchivedAuthorEntityList(List<AuthorEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<ArchivedAuthorEntity> list1 = new ArrayList<ArchivedAuthorEntity>( list.size() );
        for ( AuthorEntity authorEntity : list ) {
            list1.add( archivedAuthorMapper.toArchivedEntity( authorEntity ) );
        }

        return list1;
    }
}
