/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.dm.mapper;

import com.finconsgroup.itserr.marketplace.news.dm.dto.InputAuthorDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.InputCreateNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.InputImageDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.InputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.InputUpdateNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.OutputAuthorDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.OutputImageDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.OutputNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.entity.AuthorEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.NewsEntity;
import com.finconsgroup.itserr.marketplace.news.dm.mapper.AuthorMapper;
import com.finconsgroup.itserr.marketplace.news.dm.mapper.NewsMapper;
import com.finconsgroup.itserr.marketplace.news.dm.model.InstitutionalPageModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsMapperImpl
implements NewsMapper {
    @Autowired
    private AuthorMapper authorMapper;

    public NewsEntity toEntity(InputCreateNewsDto inputCreateNewsDto) {
        if (inputCreateNewsDto == null) {
            return null;
        }
        NewsEntity.NewsEntityBuilder newsEntity = NewsEntity.builder();
        newsEntity.imageId(this.inputCreateNewsDtoImageId(inputCreateNewsDto));
        newsEntity.imageUrl(this.inputCreateNewsDtoImageUrl(inputCreateNewsDto));
        newsEntity.title(inputCreateNewsDto.getTitle());
        newsEntity.newsType(inputCreateNewsDto.getNewsType());
        newsEntity.content(inputCreateNewsDto.getContent());
        List list = inputCreateNewsDto.getTags();
        if (list != null) {
            newsEntity.tags(new ArrayList(list));
        }
        newsEntity.institutionalPages(this.inputInstitutionalPageDtoListToInstitutionalPageModelList(inputCreateNewsDto.getInstitutionalPages()));
        List list2 = inputCreateNewsDto.getRegisteredAuthorIds();
        if (list2 != null) {
            newsEntity.registeredAuthorIds(new ArrayList(list2));
        }
        newsEntity.unRegisteredAuthors(this.inputAuthorDtoListToAuthorEntityList(inputCreateNewsDto.getUnRegisteredAuthors()));
        NewsEntity newsEntityResult = newsEntity.build();
        this.setUnregisteredAuthors(newsEntityResult);
        return newsEntityResult;
    }

    public OutputNewsDto toDto(NewsEntity newsEntity) {
        if (newsEntity == null) {
            return null;
        }
        OutputNewsDto.OutputNewsDtoBuilder outputNewsDto = OutputNewsDto.builder();
        outputNewsDto.image(this.newsEntityToOutputImageDto(newsEntity));
        List list = newsEntity.getTags();
        if (list != null) {
            outputNewsDto.tags(new ArrayList(list));
        } else {
            outputNewsDto.tags(Collections.emptyList());
        }
        List list1 = newsEntity.getRegisteredAuthorIds();
        if (list1 != null) {
            outputNewsDto.registeredAuthorIds(new ArrayList(list1));
        } else {
            outputNewsDto.registeredAuthorIds(Collections.emptyList());
        }
        outputNewsDto.id(newsEntity.getId());
        outputNewsDto.title(newsEntity.getTitle());
        outputNewsDto.creatorId(newsEntity.getCreatorId());
        outputNewsDto.newsType(newsEntity.getNewsType());
        outputNewsDto.content(newsEntity.getContent());
        outputNewsDto.institutionalPages(this.institutionalPageModelListToOutputInstitutionalPageDtoList(newsEntity.getInstitutionalPages()));
        outputNewsDto.unRegisteredAuthors(this.authorEntityListToOutputAuthorDtoList(newsEntity.getUnRegisteredAuthors()));
        outputNewsDto.creationTime(newsEntity.getCreationTime());
        outputNewsDto.updateTime(newsEntity.getUpdateTime());
        return outputNewsDto.build();
    }

    public void updateEntity(InputUpdateNewsDto dto, NewsEntity entity) {
        if (dto == null) {
            return;
        }
        entity.setImageId(this.dtoImageId(dto));
        entity.setImageUrl(this.dtoImageUrl(dto));
        entity.setTitle(dto.getTitle());
        entity.setNewsType(dto.getNewsType());
        entity.setContent(dto.getContent());
        if (entity.getTags() != null) {
            list = dto.getTags();
            if (list != null) {
                entity.getTags().clear();
                entity.getTags().addAll(list);
            } else {
                entity.setTags(null);
            }
        } else {
            list = dto.getTags();
            if (list != null) {
                entity.setTags(new ArrayList(list));
            }
        }
        if (entity.getInstitutionalPages() != null) {
            list1 = this.inputInstitutionalPageDtoListToInstitutionalPageModelList(dto.getInstitutionalPages());
            if (list1 != null) {
                entity.getInstitutionalPages().clear();
                entity.getInstitutionalPages().addAll(list1);
            } else {
                entity.setInstitutionalPages(null);
            }
        } else {
            list1 = this.inputInstitutionalPageDtoListToInstitutionalPageModelList(dto.getInstitutionalPages());
            if (list1 != null) {
                entity.setInstitutionalPages(list1);
            }
        }
        if (entity.getRegisteredAuthorIds() != null) {
            list2 = dto.getRegisteredAuthorIds();
            if (list2 != null) {
                entity.getRegisteredAuthorIds().clear();
                entity.getRegisteredAuthorIds().addAll(list2);
            } else {
                entity.setRegisteredAuthorIds(null);
            }
        } else {
            list2 = dto.getRegisteredAuthorIds();
            if (list2 != null) {
                entity.setRegisteredAuthorIds(new ArrayList(list2));
            }
        }
        if (entity.getUnRegisteredAuthors() != null) {
            list3 = this.inputAuthorDtoListToAuthorEntityList(dto.getUnRegisteredAuthors());
            if (list3 != null) {
                entity.getUnRegisteredAuthors().clear();
                entity.getUnRegisteredAuthors().addAll(list3);
            } else {
                entity.setUnRegisteredAuthors(null);
            }
        } else {
            list3 = this.inputAuthorDtoListToAuthorEntityList(dto.getUnRegisteredAuthors());
            if (list3 != null) {
                entity.setUnRegisteredAuthors(list3);
            }
        }
        this.setUnregisteredAuthors(entity);
    }

    private UUID inputCreateNewsDtoImageId(InputCreateNewsDto inputCreateNewsDto) {
        InputImageDto image = inputCreateNewsDto.getImage();
        if (image == null) {
            return null;
        }
        return image.getId();
    }

    private String inputCreateNewsDtoImageUrl(InputCreateNewsDto inputCreateNewsDto) {
        InputImageDto image = inputCreateNewsDto.getImage();
        if (image == null) {
            return null;
        }
        return image.getUrl();
    }

    protected InstitutionalPageModel inputInstitutionalPageDtoToInstitutionalPageModel(InputInstitutionalPageDto inputInstitutionalPageDto) {
        if (inputInstitutionalPageDto == null) {
            return null;
        }
        InstitutionalPageModel.InstitutionalPageModelBuilder institutionalPageModel = InstitutionalPageModel.builder();
        institutionalPageModel.id(inputInstitutionalPageDto.getId());
        institutionalPageModel.name(inputInstitutionalPageDto.getName());
        return institutionalPageModel.build();
    }

    protected List<InstitutionalPageModel> inputInstitutionalPageDtoListToInstitutionalPageModelList(List<InputInstitutionalPageDto> list) {
        if (list == null) {
            return null;
        }
        ArrayList<InstitutionalPageModel> list1 = new ArrayList<InstitutionalPageModel>(list.size());
        for (InputInstitutionalPageDto inputInstitutionalPageDto : list) {
            list1.add(this.inputInstitutionalPageDtoToInstitutionalPageModel(inputInstitutionalPageDto));
        }
        return list1;
    }

    protected List<AuthorEntity> inputAuthorDtoListToAuthorEntityList(List<InputAuthorDto> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AuthorEntity> list1 = new ArrayList<AuthorEntity>(list.size());
        for (InputAuthorDto inputAuthorDto : list) {
            list1.add(this.authorMapper.toEntity(inputAuthorDto));
        }
        return list1;
    }

    protected OutputImageDto newsEntityToOutputImageDto(NewsEntity newsEntity) {
        if (newsEntity == null) {
            return null;
        }
        OutputImageDto.OutputImageDtoBuilder outputImageDto = OutputImageDto.builder();
        outputImageDto.id(newsEntity.getImageId());
        outputImageDto.url(newsEntity.getImageUrl());
        return outputImageDto.build();
    }

    protected OutputInstitutionalPageDto institutionalPageModelToOutputInstitutionalPageDto(InstitutionalPageModel institutionalPageModel) {
        if (institutionalPageModel == null) {
            return null;
        }
        OutputInstitutionalPageDto.OutputInstitutionalPageDtoBuilder outputInstitutionalPageDto = OutputInstitutionalPageDto.builder();
        outputInstitutionalPageDto.id(institutionalPageModel.getId());
        outputInstitutionalPageDto.name(institutionalPageModel.getName());
        return outputInstitutionalPageDto.build();
    }

    protected List<OutputInstitutionalPageDto> institutionalPageModelListToOutputInstitutionalPageDtoList(List<InstitutionalPageModel> list) {
        if (list == null) {
            return new ArrayList<OutputInstitutionalPageDto>();
        }
        ArrayList<OutputInstitutionalPageDto> list1 = new ArrayList<OutputInstitutionalPageDto>(list.size());
        for (InstitutionalPageModel institutionalPageModel : list) {
            list1.add(this.institutionalPageModelToOutputInstitutionalPageDto(institutionalPageModel));
        }
        return list1;
    }

    protected List<OutputAuthorDto> authorEntityListToOutputAuthorDtoList(List<AuthorEntity> list) {
        if (list == null) {
            return new ArrayList<OutputAuthorDto>();
        }
        ArrayList<OutputAuthorDto> list1 = new ArrayList<OutputAuthorDto>(list.size());
        for (AuthorEntity authorEntity : list) {
            list1.add(this.authorMapper.toDto(authorEntity));
        }
        return list1;
    }

    private UUID dtoImageId(InputUpdateNewsDto inputUpdateNewsDto) {
        InputImageDto image = inputUpdateNewsDto.getImage();
        if (image == null) {
            return null;
        }
        return image.getId();
    }

    private String dtoImageUrl(InputUpdateNewsDto inputUpdateNewsDto) {
        InputImageDto image = inputUpdateNewsDto.getImage();
        if (image == null) {
            return null;
        }
        return image.getUrl();
    }
}

