package com.finconsgroup.itserr.marketplace.news.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.news.dm.api.NewsApi;
import com.finconsgroup.itserr.marketplace.news.dm.dto.InputCreateNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.InputUpdateNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.OutputNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.service.NewsService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * REST controller class for handling user news related API requests.
 *
 * <p>Implements the {@link NewsApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class NewsController implements NewsApi {

    private final NewsService newsService;

    @Override
    public Page<OutputNewsDto> findAll(
            final int pageNumber,
            final int pageSize,
            final String sort,
            final Sort.Direction direction
    ) {
        Pageable pageable = PageRequest.of(pageNumber, pageSize, direction, sort);
        return newsService.findAll(pageable);
    }

    @Override
    public OutputNewsDto findById(final UUID newsId) {
        return newsService.findById(newsId);
    }

    @Override
    public OutputNewsDto createNews(final InputCreateNewsDto inputCreateNewsDto) {
        return newsService.create(JwtTokenHolder.getUserIdOrThrow(), inputCreateNewsDto);
    }

    @Override
    public OutputNewsDto updateNewsById(
            final UUID newsId,
            final InputUpdateNewsDto inputUpdateNewsDto
    ) {
        return newsService.updateById(JwtTokenHolder.getUserIdOrThrow(), newsId, inputUpdateNewsDto);
    }

    @Override
    public void deleteNewsById(final UUID newsId) {
        newsService.deleteById(JwtTokenHolder.getUserIdOrThrow(), newsId);
    }

}
