/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.news.bs.api.DiagnosticsApi;
import com.finconsgroup.itserr.marketplace.news.bs.bean.NewsApplicationEvent;
import com.finconsgroup.itserr.marketplace.news.bs.config.properties.NewsBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.news.bs.dto.OutputNewsDetailDto;
import com.finconsgroup.itserr.marketplace.news.bs.enums.EventType;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class DiagnosticsController
implements DiagnosticsApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiagnosticsController.class);
    private final ApplicationEventPublisher applicationEventPublisher;
    private final NewsBsConfigurationProperties newsBsConfigurationProperties;
    private static final Map<String, OutputNewsDetailDto> itemMap = new HashMap();
    @Value(value="${log.log4j2-rolling-file-name}")
    private String log4j2RollingFileName;

    public ResponseEntity<Resource> downloadLogs() {
        log.debug("call to DiagnosticsController - downloadLogs");
        Path filePath = Paths.get(this.getLogFilePathFromLog4j2(), new String[0]);
        log.debug("Trying to retrieve log file from: {}", (Object)filePath);
        File logFile = filePath.toFile();
        if (!logFile.exists() || !logFile.isFile()) {
            throw new WP2ResourceNotFoundException("Log file not found: %s".formatted(logFile.getAbsolutePath()));
        }
        FileSystemResource resource = new FileSystemResource(logFile);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{DiagnosticsController.getContentDispositionHeaderValue((String)logFile.getName())})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
    }

    public String getLogFilePathFromLog4j2() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        RollingFileAppender appender = (RollingFileAppender)context.getConfiguration().getAppender(this.log4j2RollingFileName);
        return appender.getFileName();
    }

    private static String getContentDispositionHeaderValue(String fileName) {
        return "attachment; filename=\"%s\"".formatted(fileName);
    }

    public ResponseEntity<String> publishMessage(EventType eventType, String itemName) {
        OutputNewsDetailDto newsDetailDto;
        if (!this.newsBsConfigurationProperties.getDiagnostics().isPublishMessageEnabled()) {
            log.warn("Attempt to access disabled diagnostics endpoint");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"This endpoint is disabled in the current environment");
        }
        log.debug("call to DiagnosticsController - publishMessage, name: %s".formatted(itemName));
        EventType eventType2 = eventType;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CREATED", "UPDATED", "DELETED"}, (EventType)eventType2, n)) {
            case 0: {
                newsDetailDto = OutputNewsDetailDto.builder().id(UUID.randomUUID()).title(itemName).content("CREATED News content").build();
                log.info("sending created event message, newsDetailDto: %s".formatted(newsDetailDto));
                itemMap.put(newsDetailDto.getTitle(), newsDetailDto);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new NewsApplicationEvent(newsDetailDto, EventType.CREATED));
                break;
            }
            case 1: {
                newsDetailDto = (OutputNewsDetailDto)itemMap.get(itemName);
                if (newsDetailDto == null) {
                    return ResponseEntity.badRequest().body((Object)"no test item created for itemName: %s".formatted(itemName));
                }
                newsDetailDto.setContent("the UPDATED content");
                log.info("sending updated event message, newsDetailDto: %s".formatted(newsDetailDto));
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new NewsApplicationEvent(newsDetailDto, EventType.UPDATED));
                break;
            }
            case 2: {
                newsDetailDto = (OutputNewsDetailDto)itemMap.get(itemName);
                if (newsDetailDto == null) {
                    return ResponseEntity.badRequest().body((Object)"no test item created for itemName: %s".formatted(itemName));
                }
                log.info("sending deleted message, newsDetailDto: %s".formatted(newsDetailDto));
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new NewsApplicationEvent(newsDetailDto, EventType.DELETED));
                itemMap.remove(newsDetailDto.getTitle());
                break;
            }
            default: {
                return ResponseEntity.badRequest().body((Object)"Event type must be one of: CREATED, UPDATED, DELETED, APPROVED or REJECTED");
            }
        }
        return ResponseEntity.ok((Object)"message sent correctly, newsDetailDto: %s".formatted(newsDetailDto));
    }

    @Generated
    public DiagnosticsController(ApplicationEventPublisher applicationEventPublisher, NewsBsConfigurationProperties newsBsConfigurationProperties) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.newsBsConfigurationProperties = newsBsConfigurationProperties;
    }
}

