package com.finconsgroup.itserr.marketplace.news.bs.dto;

import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.OutputImageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

/**
 * Output DTO representing news.
 */
@Schema(name = "OutputNewsDetailDto", description = "DTO representing a news details in responses")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputNewsDetailDto {

    @Schema(description = "Unique identifier of the news", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "The title of the news", example = "Annual Tech Conference 2025")
    private String title;

    @Schema(description = "The creator of the News")
    private OutputNewsAuthorDto creator;

    @Schema(description = "The type of news", example = "Technology")
    private String newsType;

    @Schema(description = "The content of the news")
    private String content;

    @Schema(description = "List of tags associated with the news")
    private List<String> tags;

    @Schema(description = "List of institutional pages")
    private List<OutputNewsInstitutionalPageDto> institutionalPages;

    @Schema(description = "Image")
    private OutputImageDto image;

    @Schema(description = "Authors registered and unregistered of the News")
    private List<OutputNewsAuthorDto> authors;

    @Schema(description = "The creation time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant creationTime;

    @Schema(description = "The last update time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant updateTime;
}
