package com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.net.URI;
import java.util.UUID;

/**
 * Output DTO for image.
 */
@Schema(name = "OutputImageDto", description = "DTO representing a image in responses")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputImageDto {

    @Schema(description = "The document ID of the image", example = "123e4567-e89b-12d3-a456-426614174002")
    private UUID id;

    @Schema(description = "Public URL of the image", example = "https://example.com/images/tech-conference-2025.jpg")
    private URI url;
}
