/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.bs.messaging.impl;

import com.finconsgroup.itserr.marketplace.news.bs.config.properties.NewsBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.news.bs.dto.OutputNewsDetailDto;
import com.finconsgroup.itserr.marketplace.news.bs.messaging.ResourceProducer;
import com.finconsgroup.itserr.messaging.exception.WP2MessagingException;
import com.finconsgroup.itserr.messaging.producer.MessageProducer;
import com.finconsgroup.itserr.messaging.producer.ProducerRegistry;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"messaging.enabled"}, havingValue="true")
public class DefaultResourceProducer
implements ResourceProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultResourceProducer.class);
    private final MessageProducer messageProducer;
    private final NewsBsConfigurationProperties.Messaging messagingProperties;

    public DefaultResourceProducer(NewsBsConfigurationProperties bsConfigurationProperties, ProducerRegistry producerRegistry) {
        this.messagingProperties = bsConfigurationProperties.getMessaging();
        this.messageProducer = producerRegistry.getMessageProducer(this.messagingProperties.getProducerName());
    }

    public void publishCreatedResource(@NotNull OutputNewsDetailDto resource) {
        this.publish(resource, this.messagingProperties.getResourceCreatedType());
    }

    public void publishUpdatedResource(@NotNull OutputNewsDetailDto resource) {
        this.publish(resource, this.messagingProperties.getResourceUpdatedType());
    }

    public void publishDeletedResource(@NotNull OutputNewsDetailDto resource) {
        this.publish(resource, this.messagingProperties.getResourceDeletedType());
    }

    private void publish(@NonNull OutputNewsDetailDto resource, @NonNull String eventType) {
        try {
            Map<String, OutputNewsDetailDto> messageMap = Map.of(resource.getId().toString(), resource);
            Map<String, String> filterProperties = Map.of("service", "news");
            log.debug("Sending message, messageMap: %s, eventType: %s, source: %s, filterProperties: %s".formatted(messageMap, eventType, this.messagingProperties.getSource(), filterProperties));
            this.messageProducer.publishEvent(messageMap, eventType, this.messagingProperties.getSource(), filterProperties);
            log.info("Successfully published message for resource with id: %s".formatted(resource.getId()));
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while sending message: %s".formatted(e.getMessage());
            throw new WP2MessagingException(errorMessage);
        }
    }
}

