/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.bs.messaging.impl;

import com.finconsgroup.itserr.marketplace.news.bs.config.properties.NewsBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.news.bs.messaging.EventProducer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.exception.WP2MessagingException;
import com.finconsgroup.itserr.messaging.producer.MessageProducer;
import com.finconsgroup.itserr.messaging.producer.ProducerRegistry;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"messaging.enabled"}, havingValue="true")
public class DefaultEventProducer
implements EventProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEventProducer.class);
    private final MessageProducer messageProducer;
    private final NewsBsConfigurationProperties.Messaging messagingProperties;

    public DefaultEventProducer(NewsBsConfigurationProperties newsBsConfigurationProperties, ProducerRegistry producerRegistry) {
        this.messagingProperties = newsBsConfigurationProperties.getMessaging();
        this.messageProducer = producerRegistry.getMessageProducer(this.messagingProperties.getEventProducerName());
    }

    public void publishCreateEvent(@NotNull MessagingEventDto<?> resource) {
        this.publish(resource, this.messagingProperties.getResourceCreatedEventType());
    }

    public void publishUpdateEvent(@NotNull MessagingEventDto<?> resource) {
        this.publish(resource, this.messagingProperties.getResourceUpdatedEventType());
    }

    public void publishDeleteEvent(@NotNull MessagingEventDto<?> resource) {
        this.publish(resource, this.messagingProperties.getResourceDeletedEventType());
    }

    private void publish(@NonNull MessagingEventDto<?> eventDto, @NonNull String eventType) {
        try {
            Map<String, MessagingEventDto<?>> messageMap = Map.of(eventDto.getId(), eventDto);
            Map<String, String> filterProperties = Map.of("service", "news");
            log.debug("Sending message, messageMap: {}, eventType: {}, source: {}, filterProperties: {}", new Object[]{messageMap, eventType, this.messagingProperties.getSource(), filterProperties});
            this.messageProducer.publishEvent(messageMap, eventType, this.messagingProperties.getSource(), filterProperties);
            log.info("Successfully published event message for resource with id: {}", (Object)eventDto.getId());
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while sending event message: %s".formatted(e.getMessage());
            throw new WP2MessagingException(errorMessage);
        }
    }
}

