package com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import static com.finconsgroup.itserr.marketplace.news.bs.util.ValidationConstants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.news.bs.util.ValidationConstants.VALIDATION_NAME_LENGTH;
import static com.finconsgroup.itserr.marketplace.news.bs.util.ValidationConstants.VALIDATION_ORCID_LENGTH;
import static com.finconsgroup.itserr.marketplace.news.bs.util.ValidationConstants.VALIDATION_URL_LENGTH;


/**
 * DTO for author details.
 */
@Schema(name = "InputAuthorDto", description = "DTO for author details")
@Data
@Builder
@AllArgsConstructor
public class InputAuthorDto {

    @Schema(description = "First name of the user", example = "John")
    @Size(max = VALIDATION_NAME_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String firstName;

    @Schema(description = "Last name of the user", example = "Doe")
    @Size(max = VALIDATION_NAME_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String lastName;

    @Schema(description = "Email address of the user", example = "john.doe@example.com")
    @Size(max = VALIDATION_URL_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String email;

    @Schema(description = "ORCID of the author", example = "0000-0002-1825-0097")
    @Size(max = VALIDATION_ORCID_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String orcid;

    @Valid
    private InputLocationDto location;
}
