package com.finconsgroup.itserr.marketplace.news.bs.client.dto.institutionalpage;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.UUID;

/**
 * It represents the response for an Institutional Page in news.
 */
@Schema(
        title = "Institutional Page response DTO for news",
        description = "Represents the response for Institutional in news "
)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputSearchPublishedInstitutionalPageDto {

    @Schema(description = "ID of the institutional page", example = "11111111-aaaa-0000-0000-000000000000")
    private UUID id;

    @Schema(description = "The name of the institutional page", example = "Criterion")
    private String name;
}
