/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.feeder.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.finconsgroup.itserr.marketplace.metrics.feeder.client.MetricsBsClient;
import com.finconsgroup.itserr.marketplace.metrics.feeder.config.properties.MetricsFeederConfigurationProperties;
import com.finconsgroup.itserr.marketplace.metrics.feeder.dto.favouriteuserbs.FavouriteItemMessageBodyDto;
import com.finconsgroup.itserr.marketplace.metrics.feeder.dto.metricbs.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.feeder.dto.metricbs.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.feeder.dto.metricbs.OutputMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.feeder.messaging.AbstractMetricEventConsumer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import feign.FeignException;
import io.cloudevents.CloudEvent;
import java.time.ZoneOffset;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component(value="favouriteUserEventConsumer")
public class FavouriteUserEventConsumer
extends AbstractMetricEventConsumer<FavouriteItemMessageBodyDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FavouriteUserEventConsumer.class);
    private final MetricsBsClient metricsBsClient;
    private final String resourceDeletedEventType;

    public FavouriteUserEventConsumer(MetricsFeederConfigurationProperties config, MetricsBsClient metricsBsClient) {
        super(metricsBsClient, MetricDtoType.CATALOG_ITEM_FAVOURITE, config.getMessaging().getFavouriteUser().getResourceCreatedEventType(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.metricsBsClient = metricsBsClient;
        this.resourceDeletedEventType = config.getMessaging().getFavouriteUser().getResourceDeletedEventType();
    }

    protected void handleEvent(FavouriteItemMessageBodyDto resourcePayload, @NonNull CloudEvent event) {
        if (this.resourceDeletedEventType.equals(event.getType())) {
            this.handleDeleteEvent(resourcePayload, event);
        } else {
            super.handleEvent((MessagingEventDto)resourcePayload, event);
        }
    }

    private void handleDeleteEvent(FavouriteItemMessageBodyDto resourcePayload, @NonNull CloudEvent event) {
        if (resourcePayload == null) {
            log.warn("Received {} event with no payload. Message will be dropped.", (Object)this.resourceDeletedEventType);
            return;
        }
        if (resourcePayload.getTimestamp() == null) {
            log.warn("Received {} event with no timestamp. Message will be dropped.", (Object)this.resourceDeletedEventType);
            return;
        }
        if (resourcePayload.getUser() == null || resourcePayload.getUser().getId() == null) {
            log.warn("Received {} event with no user id. Message will be dropped.", (Object)this.resourceDeletedEventType);
            return;
        }
        if (StringUtils.isBlank((CharSequence)resourcePayload.getCategory())) {
            log.warn("Received {} event with no category. Message will be dropped.", (Object)this.resourceDeletedEventType);
            return;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)resourcePayload.getCategory(), (CharSequence)"CATALOG")) {
            log.info("Received {} event for non-catalog category (type={}). Skipping.", (Object)this.resourceDeletedEventType, (Object)resourcePayload.getCategory());
            return;
        }
        if (resourcePayload.getAdditionalData() == null || StringUtils.isBlank((CharSequence)((FavouriteItemMessageBodyDto.AdditionalData)resourcePayload.getAdditionalData()).getItemId())) {
            log.warn("Received {} event with no item id. Message will be dropped.", (Object)this.resourceDeletedEventType);
            return;
        }
        String resourceId = ((FavouriteItemMessageBodyDto.AdditionalData)resourcePayload.getAdditionalData()).getItemId();
        String eventAuthor = resourcePayload.getUser().getId().toString();
        InputCreateMetricEventDto metricEvent = InputCreateMetricEventDto.builder().eventTime(resourcePayload.getTimestamp().atZone(ZoneOffset.UTC)).eventAuthor(eventAuthor).resourceId(resourceId).build();
        try {
            OutputMetricEventDto created = this.metricsBsClient.createMetricEvent(MetricDtoType.CATALOG_ITEM_UNFAVOURITE, metricEvent);
            log.debug("Created unfavourite metric event: {}", (Object)created.getId());
        }
        catch (FeignException.Conflict e) {
            log.info("Unfavourite metric event already exists for resource {} by author {}. Skipping.", (Object)resourceId, (Object)eventAuthor);
        }
    }

    protected void fillMetricEvent(@NonNull InputCreateMetricEventDto.InputCreateMetricEventDtoBuilder metricEventBuilder, @NonNull FavouriteItemMessageBodyDto resourcePayload, @NonNull CloudEvent event) throws AbstractMetricEventConsumer.ValidationException {
        if (StringUtils.isBlank((CharSequence)resourcePayload.getCategory())) {
            throw new AbstractMetricEventConsumer.ValidationException("no category");
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)resourcePayload.getCategory(), (CharSequence)"CATALOG")) {
            throw new AbstractMetricEventConsumer.ValidationException("not a catalog item favourite (type=" + resourcePayload.getCategory() + ")", false);
        }
        if (resourcePayload.getAdditionalData() == null) {
            throw new AbstractMetricEventConsumer.ValidationException("no additional data");
        }
        if (StringUtils.isBlank((CharSequence)((FavouriteItemMessageBodyDto.AdditionalData)resourcePayload.getAdditionalData()).getItemId())) {
            throw new AbstractMetricEventConsumer.ValidationException("no item id");
        }
        String itemId = ((FavouriteItemMessageBodyDto.AdditionalData)resourcePayload.getAdditionalData()).getItemId();
        metricEventBuilder.resourceId(itemId);
    }
}

