package com.finconsgroup.itserr.marketplace.metrics.feeder.config.properties;

import jakarta.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.validation.annotation.Validated;

/**
 * Configuration for favourite-user-bs messaging.
 */
@Validated
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MessagingFavouriteUserBsProperties {

    /**
     * Event type string used for resource creation events.
     */
    @NotBlank
    private String resourceCreatedEventType;

    /**
     * Event type string used for resource deletion events.
     */
    @NotBlank
    private String resourceDeletedEventType;

}
