/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.feeder.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.finconsgroup.itserr.marketplace.metrics.feeder.client.MetricsBsClient;
import com.finconsgroup.itserr.marketplace.metrics.feeder.config.properties.MetricsFeederConfigurationProperties;
import com.finconsgroup.itserr.marketplace.metrics.feeder.dto.discussionbs.DiscussionThreadCreatedMessageBodyDto;
import com.finconsgroup.itserr.marketplace.metrics.feeder.dto.metricbs.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.feeder.dto.metricbs.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.feeder.messaging.AbstractMetricEventConsumer;
import io.cloudevents.CloudEvent;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component(value="discussionEventConsumer")
public class DiscussionEventConsumer
extends AbstractMetricEventConsumer<DiscussionThreadCreatedMessageBodyDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiscussionEventConsumer.class);

    public DiscussionEventConsumer(MetricsFeederConfigurationProperties config, MetricsBsClient metricsBsClient) {
        super(metricsBsClient, MetricDtoType.CATALOG_ITEM_COMMENT, config.getMessaging().getDiscussion().getThreadCreatedEventType(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void fillMetricEvent(@NonNull InputCreateMetricEventDto.InputCreateMetricEventDtoBuilder metricEventBuilder, @NonNull DiscussionThreadCreatedMessageBodyDto payload, @NonNull CloudEvent event) throws AbstractMetricEventConsumer.ValidationException {
        if (payload.getAdditionalData() == null) {
            throw new AbstractMetricEventConsumer.ValidationException("no additional data");
        }
        if (StringUtils.isBlank((CharSequence)((DiscussionThreadCreatedMessageBodyDto.AdditionalData)payload.getAdditionalData()).getDiscussionResourceId())) {
            throw new AbstractMetricEventConsumer.ValidationException("no discussion resource id");
        }
        if (StringUtils.isBlank((CharSequence)((DiscussionThreadCreatedMessageBodyDto.AdditionalData)payload.getAdditionalData()).getDiscussionResourceType())) {
            throw new AbstractMetricEventConsumer.ValidationException("no discussion resource type");
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)((DiscussionThreadCreatedMessageBodyDto.AdditionalData)payload.getAdditionalData()).getDiscussionResourceType(), (CharSequence)"item")) {
            throw new AbstractMetricEventConsumer.ValidationException("not a catalog item discussion (type=" + ((DiscussionThreadCreatedMessageBodyDto.AdditionalData)payload.getAdditionalData()).getDiscussionResourceType() + ")", false);
        }
        String itemId = ((DiscussionThreadCreatedMessageBodyDto.AdditionalData)payload.getAdditionalData()).getDiscussionResourceId();
        metricEventBuilder.resourceId(itemId);
    }
}

