package com.finconsgroup.itserr.marketplace.metrics.feeder.dto.metricbs;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.time.ZonedDateTime;

/**
 * Input DTO for creating a metricEvent.
 */
@Data
@Builder
@AllArgsConstructor
public class InputCreateMetricEventDto {

    /**
     * The unique identifier of the resource for which the metric event is being created.
     */
    private String resourceId;

    /**
     * Represents the author of the event being recorded.
     */
    private String eventAuthor;

    /**
     * The timestamp when the metric event occurred. Represents the exact date and time in a specific time zone.
     */
    private ZonedDateTime eventTime;

}
