/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.repository;

import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricEventDailyCount;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.projection.MetricDashboardView;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.projection.MetricReportProjection;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.projection.MetricSummaryProjection;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;

@Repository
public interface MetricEventDailyCountRepository
extends JpaRepository<MetricEventDailyCount, MetricEventDailyCount.EntityId> {
    public List<MetricEventDailyCount> findByResourceIdInAndEventDayBetween(Collection<String> var1, LocalDate var2, LocalDate var3);

    @Query(value="SELECT   new com.finconsgroup.itserr.marketplace.metrics.dm.entity.projection.MetricSummaryProjection(m.metric, SUM(m.eventsCount))\nFROM     MetricEventDailyCount m\nWHERE    m.resourceId IN :resourcesIds\nGROUP BY m.metric\nORDER BY m.metric\n")
    public List<MetricSummaryProjection> summarizeByResourceIds(@NonNull @Param(value="resourcesIds") Collection<String> var1);

    @Query(value="SELECT   new com.finconsgroup.itserr.marketplace.metrics.dm.entity.projection.MetricSummaryProjection(m.metric, SUM(m.eventsCount))\nFROM     MetricEventDailyCount m\nWHERE    m.resourceId IN :resourcesIds\n    AND  m.eventDay <= :endDate\nGROUP BY m.metric\nORDER BY m.metric\n")
    public List<MetricSummaryProjection> summarizeByResourceIdsAndEndDate(@NonNull @Param(value="resourcesIds") Collection<String> var1, @NonNull @Param(value="endDate") LocalDate var2);

    @Query(value="SELECT   new com.finconsgroup.itserr.marketplace.metrics.dm.entity.projection.MetricReportProjection(m.metric, SUM(m.eventsCount))\nFROM     MetricEventDailyCount m\nWHERE    m.resourceId IN :resourcesIds\n     AND (CAST(:fromDate AS DATE) IS NULL or m.eventDay >= :fromDate)\n     AND (CAST(:toDate AS DATE) IS NULL or m.eventDay <= :toDate)\nGROUP BY m.metric\nORDER BY m.metric\n")
    public List<MetricReportProjection> summarizeReportByGranularityUser(@NonNull @Param(value="resourcesIds") Collection<String> var1, @Param(value="fromDate") LocalDate var2, @Param(value="toDate") LocalDate var3);

    @Query(value="SELECT   new com.finconsgroup.itserr.marketplace.metrics.dm.entity.projection.MetricReportProjection(m.resourceId, m.metric, SUM(m.eventsCount))\nFROM     MetricEventDailyCount m\nWHERE    m.resourceId IN :resourcesIds\n     AND (CAST(:fromDate AS DATE) IS NULL or m.eventDay >= :fromDate)\n     AND (CAST(:toDate AS DATE) IS NULL or m.eventDay <= :toDate)\nGROUP BY m.resourceId, m.metric\nORDER BY m.resourceId, m.metric\n")
    public List<MetricReportProjection> summarizeReportByGranularityResource(@NonNull @Param(value="resourcesIds") Collection<String> var1, @Param(value="fromDate") LocalDate var2, @Param(value="toDate") LocalDate var3);

    @Query(value="SELECT   new com.finconsgroup.itserr.marketplace.metrics.dm.entity.projection.MetricReportProjection(m.eventDay, m.metric, SUM(m.eventsCount))\nFROM     MetricEventDailyCount m\nWHERE    m.resourceId IN :resourcesIds\n     AND (CAST(:fromDate AS DATE) IS NULL or m.eventDay >= :fromDate)\n     AND (CAST(:toDate AS DATE) IS NULL or m.eventDay <= :toDate)\nGROUP BY m.eventDay, m.metric\nORDER BY m.eventDay, m.metric\n")
    public List<MetricReportProjection> summarizeReportByGranularityDate(@NonNull @Param(value="resourcesIds") Collection<String> var1, @Param(value="fromDate") LocalDate var2, @Param(value="toDate") LocalDate var3);

    @Query(value="SELECT   new com.finconsgroup.itserr.marketplace.metrics.dm.entity.projection.MetricReportProjection(m.resourceId, m.eventDay, m.metric, m.eventsCount)\nFROM     MetricEventDailyCount m\nWHERE    m.resourceId IN :resourcesIds\n     AND (CAST(:fromDate AS DATE) IS NULL or m.eventDay >= :fromDate)\n     AND (CAST(:toDate AS DATE) IS NULL or m.eventDay <= :toDate)\nORDER BY m.resourceId, m.eventDay, m.metric\n")
    public List<MetricReportProjection> summarizeReportByGranularityResourceDate(@NonNull @Param(value="resourcesIds") Collection<String> var1, @Param(value="fromDate") LocalDate var2, @Param(value="toDate") LocalDate var3);

    @Query(value="select\n    cast(:toDate as DATE) as event_day,\n    NULL as date_part,\n    COUNT(distinct m.resource_id) resource_count,\n    coalesce(SUM(case when metric = 'CATALOG_ITEM_DOWNLOAD' then events_count end), 0) as downloads,\n    coalesce(SUM(case when metric = 'CATALOG_ITEM_VIEW' then events_count end), 0) as views,\n    coalesce(SUM(case\n                    when metric = 'CATALOG_ITEM_FAVOURITE' then events_count\n                    when metric = 'CATALOG_ITEM_UNFAVOURITE' then -events_count\n                 end), 0) as favourites,\n    coalesce(SUM(case when metric = 'CATALOG_ITEM_COMMENT' then events_count end), 0) as comments\n from\n    metric_event_daily_counts m\n where \t(cast(:fromDate as DATE) is null or m.event_day >= :fromDate)\n    and (cast(:toDate as DATE) is null or m.event_day <= :toDate)\n", nativeQuery=true)
    public List<MetricDashboardView> aggregateDashboardByTimeResolutionNone(@Param(value="fromDate") LocalDate var1, @Param(value="toDate") LocalDate var2);

    @Query(value="select\n    m.event_day,\n    NULL as date_part,\n    COUNT(distinct m.resource_id) resource_count,\n    coalesce(SUM(case when metric = 'CATALOG_ITEM_DOWNLOAD' then events_count end), 0) as downloads,\n    coalesce(SUM(case when metric = 'CATALOG_ITEM_VIEW' then events_count end), 0) as views,\n    coalesce(SUM(case\n                    when metric = 'CATALOG_ITEM_FAVOURITE' then events_count\n                    when metric = 'CATALOG_ITEM_UNFAVOURITE' then -events_count\n                 end), 0) as favourites,\n    coalesce(SUM(case when metric = 'CATALOG_ITEM_COMMENT' then events_count end), 0) as comments\n from\n    metric_event_daily_counts m\n where \t(cast(:fromDate as DATE) is null or m.event_day >= :fromDate)\n    and (cast(:toDate as DATE) is null or m.event_day <= :toDate)\n GROUP BY m.event_day\n ORDER BY m.event_day\n", nativeQuery=true)
    public List<MetricDashboardView> aggregateDashboardByTimeResolutionDaily(@Param(value="fromDate") LocalDate var1, @Param(value="toDate") LocalDate var2);

    @Query(value="select\n    null,\n    to_char(m.event_day, 'YYYY-mm') as date_part,\n    COUNT(distinct m.resource_id) resource_count,\n    coalesce(SUM(case when metric = 'CATALOG_ITEM_DOWNLOAD' then events_count end), 0) as downloads,\n    coalesce(SUM(case when metric = 'CATALOG_ITEM_VIEW' then events_count end), 0) as views,\n    coalesce(SUM(case\n                    when metric = 'CATALOG_ITEM_FAVOURITE' then events_count\n                    when metric = 'CATALOG_ITEM_UNFAVOURITE' then -events_count\n                 end), 0) as favourites,\n    coalesce(SUM(case when metric = 'CATALOG_ITEM_COMMENT' then events_count end), 0) as comments\n from\n    metric_event_daily_counts m\n where \t(cast(:fromDate as DATE) is null or m.event_day >= :fromDate)\n    and (cast(:toDate as DATE) is null or m.event_day <= :toDate)\n GROUP BY to_char(m.event_day, 'YYYY-mm')\n ORDER BY to_char(m.event_day, 'YYYY-mm')\n", nativeQuery=true)
    public List<MetricDashboardView> aggregateDashboardByTimeResolutionMonthly(@Param(value="fromDate") LocalDate var1, @Param(value="toDate") LocalDate var2);

    @Query(value="select\n    null,\n    to_char(m.event_day, 'YYYY-Q') as date_part,\n    COUNT(distinct m.resource_id) resource_count,\n    coalesce(SUM(case when metric = 'CATALOG_ITEM_DOWNLOAD' then events_count end), 0) as downloads,\n    coalesce(SUM(case when metric = 'CATALOG_ITEM_VIEW' then events_count end), 0) as views,\n    coalesce(SUM(case\n                    when metric = 'CATALOG_ITEM_FAVOURITE' then events_count\n                    when metric = 'CATALOG_ITEM_UNFAVOURITE' then -events_count\n                 end), 0) as favourites,\n    coalesce(SUM(case when metric = 'CATALOG_ITEM_COMMENT' then events_count end), 0) as comments\n from\n    metric_event_daily_counts m\n where \t(cast(:fromDate as DATE) is null or m.event_day >= :fromDate)\n    and (cast(:toDate as DATE) is null or m.event_day <= :toDate)\n GROUP BY to_char(m.event_day, 'YYYY-Q')\n ORDER BY to_char(m.event_day, 'YYYY-Q')\n", nativeQuery=true)
    public List<MetricDashboardView> aggregateDashboardByTimeResolutionQuarterly(@Param(value="fromDate") LocalDate var1, @Param(value="toDate") LocalDate var2);

    @Query(value="select\n    null,\n    to_char(m.event_day, 'YYYY') as date_part,\n    COUNT(distinct m.resource_id) resource_count,\n    coalesce(SUM(case when metric = 'CATALOG_ITEM_DOWNLOAD' then events_count end), 0) as downloads,\n    coalesce(SUM(case when metric = 'CATALOG_ITEM_VIEW' then events_count end), 0) as views,\n    coalesce(SUM(case\n                    when metric = 'CATALOG_ITEM_FAVOURITE' then events_count\n                    when metric = 'CATALOG_ITEM_UNFAVOURITE' then -events_count\n                 end), 0) as favourites,\n    coalesce(SUM(case when metric = 'CATALOG_ITEM_COMMENT' then events_count end), 0) as comments\n from\n    metric_event_daily_counts m\n where \t(cast(:fromDate as DATE) is null or m.event_day >= :fromDate)\n    and (cast(:toDate as DATE) is null or m.event_day <= :toDate)\n GROUP BY to_char(m.event_day, 'YYYY')\n ORDER BY to_char(m.event_day, 'YYYY')\n", nativeQuery=true)
    public List<MetricDashboardView> aggregateDashboardByTimeResolutionYearly(@Param(value="fromDate") LocalDate var1, @Param(value="toDate") LocalDate var2);
}

