/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.mapper;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricTimeResolution;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputDashboardMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputReportMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourceMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourcesDailyMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourcesMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourcesSummaryMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricEventDailyCount;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricType;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.projection.MetricDashboardView;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.projection.MetricReportProjection;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.projection.MetricSummaryProjection;
import com.finconsgroup.itserr.marketplace.metrics.dm.mapper.MapperConfiguration;
import com.finconsgroup.itserr.marketplace.metrics.dm.mapper.MetricTypeMapper;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/*
 * Exception performing whole class analysis ignored.
 */
@Mapper(config=MapperConfiguration.class, uses={MetricTypeMapper.class})
public interface MetricMapper {
    default public OutputResourcesDailyMetricsDto toOutputResourcesDailyMetricsDto(Collection<MetricEventDailyCount> entities) {
        if (entities == null) {
            return new OutputResourcesDailyMetricsDto();
        }
        LinkedHashMap grouped = entities.stream().filter(e -> e.getResourceId() != null && e.getMetric() != null && e.getEventDay() != null).collect(Collectors.groupingBy(MetricEventDailyCount::getEventDay, LinkedHashMap::new, Collectors.groupingBy(MetricEventDailyCount::getResourceId, LinkedHashMap::new, Collectors.groupingBy(MetricEventDailyCount::getMetric, LinkedHashMap::new, Collectors.summingLong(e -> e.getEventsCount() == null ? 0L : e.getEventsCount())))));
        return this.toOutputResourcesDailyMetricsDto(grouped);
    }

    default public OutputResourcesDailyMetricsDto toOutputResourcesDailyMetricsDto(LinkedHashMap<LocalDate, LinkedHashMap<String, LinkedHashMap<MetricType, Long>>> dailyCounts) {
        MetricTypeMapper metricTypeMapper = (MetricTypeMapper)Mappers.getMapper(MetricTypeMapper.class);
        OutputResourcesDailyMetricsDto result = new OutputResourcesDailyMetricsDto();
        if (dailyCounts == null) {
            return result;
        }
        for (Map.Entry<LocalDate, LinkedHashMap<String, LinkedHashMap<MetricType, Long>>> dayEntry : dailyCounts.entrySet()) {
            LocalDate day = dayEntry.getKey();
            LinkedHashMap<String, LinkedHashMap<MetricType, Long>> dayResources = dayEntry.getValue();
            if (dayResources == null) continue;
            OutputResourcesMetricsDto resourcesMetrics = new OutputResourcesMetricsDto();
            result.put((Object)day, (Object)resourcesMetrics);
            for (Map.Entry<String, LinkedHashMap<MetricType, Long>> resEntry : dayResources.entrySet()) {
                String resourceId = resEntry.getKey();
                LinkedHashMap<MetricType, Long> resourceMetrics = resEntry.getValue();
                if (resourceId == null || resourceMetrics == null) continue;
                OutputResourceMetricsDto outResourceMetrics = new OutputResourceMetricsDto();
                LinkedHashMap<MetricDtoType, Double> metrics = new LinkedHashMap<MetricDtoType, Double>();
                outResourceMetrics.setMetrics(metrics);
                resourcesMetrics.put((Object)resourceId, (Object)outResourceMetrics);
                for (Map.Entry<MetricType, Long> metricEntry : resourceMetrics.entrySet()) {
                    MetricDtoType metricDto;
                    MetricType metric = metricEntry.getKey();
                    Long count = metricEntry.getValue();
                    if (metric == null || count == null) continue;
                    try {
                        metricDto = metricTypeMapper.metricTypeToMetricDtoType(metric);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    Double value = count.doubleValue();
                    metrics.put(metricDto, value);
                }
                MetricMapper.netUnfavouriteIntoFavourite(metrics);
            }
        }
        return result;
    }

    default public OutputResourcesSummaryMetricsDto toOutputResourcesSummaryMetricsDto(Collection<MetricSummaryProjection> metrics) {
        OutputResourcesSummaryMetricsDto result = new OutputResourcesSummaryMetricsDto();
        if (metrics != null) {
            MetricTypeMapper metricTypeMapper = (MetricTypeMapper)Mappers.getMapper(MetricTypeMapper.class);
            metrics.forEach(m -> result.put((Object)metricTypeMapper.metricTypeToMetricDtoType(m.metricType()), (Object)(m.count() != null ? m.count().doubleValue() : 0.0)));
            MetricMapper.netUnfavouriteIntoFavourite((Map)result);
        }
        return result;
    }

    default public List<OutputReportMetricsDto> toOutputReportMetricsDto(Collection<MetricReportProjection> metrics, ToDoubleFunction<OutputResourceMetricsDto> interestMapper) {
        if (metrics == null || metrics.isEmpty()) {
            return List.of();
        }
        ArrayList<OutputReportMetricsDto> result = new ArrayList<OutputReportMetricsDto>(metrics.size());
        MetricTypeMapper metricTypeMapper = (MetricTypeMapper)Mappers.getMapper(MetricTypeMapper.class);
        String lastResourceId = null;
        LocalDate lastEventDay = null;
        OutputResourcesSummaryMetricsDto metricResult = null;
        boolean isFirstIteration = true;
        for (MetricReportProjection reportMetric : metrics) {
            boolean eventDayChanged;
            boolean resourceIdChanged = lastResourceId != null && !lastResourceId.equals(reportMetric.resourceId());
            boolean bl = eventDayChanged = lastEventDay != null && !lastEventDay.equals(reportMetric.eventDay());
            if (resourceIdChanged || eventDayChanged) {
                MetricMapper.netUnfavouriteIntoFavourite(metricResult);
                OutputReportMetricsDto reportResult = this.toOutputReportMetricsDto((Map)metricResult, interestMapper, lastResourceId, lastEventDay);
                result.add(reportResult);
            }
            if (isFirstIteration || resourceIdChanged || eventDayChanged) {
                metricResult = new OutputResourcesSummaryMetricsDto();
                lastResourceId = reportMetric.resourceId();
                lastEventDay = reportMetric.eventDay();
                isFirstIteration = false;
            }
            metricResult.put((Object)metricTypeMapper.metricTypeToMetricDtoType(reportMetric.metricType()), (Object)(reportMetric.count() != null ? reportMetric.count().doubleValue() : 0.0));
        }
        if (metricResult != null) {
            MetricMapper.netUnfavouriteIntoFavourite(metricResult);
            OutputReportMetricsDto reportResult = this.toOutputReportMetricsDto(metricResult, interestMapper, lastResourceId, lastEventDay);
            result.add(reportResult);
        }
        return result;
    }

    default public OutputReportMetricsDto toOutputReportMetricsDto(Map<MetricDtoType, Double> metrics, ToDoubleFunction<OutputResourceMetricsDto> interestMapper, String resourceId, LocalDate eventDay) {
        OutputResourceMetricsDto resourceResult = OutputResourceMetricsDto.builder().metrics(metrics).build();
        return OutputReportMetricsDto.builder().resourceId(resourceId).eventDay(eventDay).interest(interestMapper.applyAsDouble(resourceResult)).downloads(metrics.getOrDefault(MetricDtoType.CATALOG_ITEM_DOWNLOAD, 0.0).longValue()).views(metrics.getOrDefault(MetricDtoType.CATALOG_ITEM_VIEW, 0.0).longValue()).favourites(metrics.getOrDefault(MetricDtoType.CATALOG_ITEM_FAVOURITE, 0.0).longValue()).comments(metrics.getOrDefault(MetricDtoType.CATALOG_ITEM_COMMENT, 0.0).longValue()).build();
    }

    private static void netUnfavouriteIntoFavourite(Map<MetricDtoType, Double> metrics) {
        Double unfavourite = metrics.remove(MetricDtoType.CATALOG_ITEM_UNFAVOURITE);
        if (unfavourite != null) {
            metrics.merge(MetricDtoType.CATALOG_ITEM_FAVOURITE, -unfavourite.doubleValue(), Double::sum);
        }
    }

    default public List<OutputDashboardMetricsDto> toOutputDashboardMetricsDto(Collection<MetricDashboardView> dashboardMetrics, MetricTimeResolution timeResolution) {
        if (dashboardMetrics == null || dashboardMetrics.isEmpty()) {
            return List.of();
        }
        ArrayList<OutputDashboardMetricsDto> metricsDtos = new ArrayList<OutputDashboardMetricsDto>(dashboardMetrics.size());
        for (MetricDashboardView dashboardMetric : dashboardMetrics) {
            LinkedHashMap<MetricDtoType, Double> metrics = new LinkedHashMap<MetricDtoType, Double>();
            metrics.put(MetricDtoType.CATALOG_ITEM_DOWNLOAD, Optional.ofNullable(dashboardMetric.getDownloads()).map(Long::doubleValue).orElse(0.0));
            metrics.put(MetricDtoType.CATALOG_ITEM_VIEW, Optional.ofNullable(dashboardMetric.getViews()).map(Long::doubleValue).orElse(0.0));
            metrics.put(MetricDtoType.CATALOG_ITEM_FAVOURITE, Optional.ofNullable(dashboardMetric.getFavourites()).map(Long::doubleValue).orElse(0.0));
            metrics.put(MetricDtoType.CATALOG_ITEM_COMMENT, Optional.ofNullable(dashboardMetric.getComments()).map(Long::doubleValue).orElse(0.0));
            OutputDashboardMetricsDto dashboardMetricsDto = OutputDashboardMetricsDto.builder().eventDay(dashboardMetric.getEventDay()).eventYear(dashboardMetric.getEventYear(timeResolution)).eventMonth(dashboardMetric.getEventMonth(timeResolution)).eventQuarter(dashboardMetric.getEventQuarter(timeResolution)).resources(dashboardMetric.getResourceCount()).metrics(metrics).build();
            metricsDtos.add(dashboardMetricsDto);
        }
        return metricsDtos;
    }
}

