/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.mapper;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.InputBeneficiaryDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputBeneficiaryDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricEventBeneficiaryEntity;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricType;
import com.finconsgroup.itserr.marketplace.metrics.dm.mapper.BeneficiaryMapper;
import com.finconsgroup.itserr.marketplace.metrics.dm.mapper.BeneficiaryMapperImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Component;

@Component
public class BeneficiaryMapperImpl
implements BeneficiaryMapper {
    public MetricEventBeneficiaryEntity toEntity(InputBeneficiaryDto src, MetricDtoType metric, UUID eventId) {
        if (src == null && metric == null && eventId == null) {
            return null;
        }
        MetricEventBeneficiaryEntity.MetricEventBeneficiaryEntityBuilder metricEventBeneficiaryEntity = MetricEventBeneficiaryEntity.builder();
        if (src != null) {
            metricEventBeneficiaryEntity.userRef(src.getUser());
        }
        metricEventBeneficiaryEntity.metric(this.metricDtoTypeToMetricType(metric));
        metricEventBeneficiaryEntity.eventId(eventId);
        return metricEventBeneficiaryEntity.build();
    }

    public OutputBeneficiaryDto toDto(MetricEventBeneficiaryEntity src) {
        if (src == null) {
            return null;
        }
        OutputBeneficiaryDto.OutputBeneficiaryDtoBuilder outputBeneficiaryDto = OutputBeneficiaryDto.builder();
        outputBeneficiaryDto.user(src.getUserRef());
        return outputBeneficiaryDto.build();
    }

    public List<OutputBeneficiaryDto> toDtoList(Collection<MetricEventBeneficiaryEntity> beneficiaries) {
        if (beneficiaries == null) {
            return null;
        }
        ArrayList<OutputBeneficiaryDto> list = new ArrayList<OutputBeneficiaryDto>(beneficiaries.size());
        for (MetricEventBeneficiaryEntity metricEventBeneficiaryEntity : beneficiaries) {
            list.add(this.toDto(metricEventBeneficiaryEntity));
        }
        return list;
    }

    protected MetricType metricDtoTypeToMetricType(MetricDtoType metricDtoType) {
        if (metricDtoType == null) {
            return null;
        }
        return switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$metrics$dm$dto$MetricDtoType[metricDtoType.ordinal()]) {
            case 1 -> MetricType.CATALOG_ITEM_DOWNLOAD;
            case 2 -> MetricType.CATALOG_ITEM_VIEW;
            case 3 -> MetricType.CATALOG_ITEM_FAVOURITE;
            case 4 -> MetricType.CATALOG_ITEM_COMMENT;
            case 5 -> MetricType.CATALOG_ITEM_UNFAVOURITE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(metricDtoType));
        };
    }
}

