/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricEventEntity;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import lombok.Generated;

@Entity
@Table(name="metric_event")
@IdClass(value=MetricEventId.class)
public class MetricEventEntity
extends AbstractUUIDEntity {
    @Id
    @Enumerated(value=EnumType.STRING)
    @Column(name="metric", nullable=false)
    private MetricType metric;
    @Column(name="resource_id", nullable=false)
    private String resourceId;
    @Column(name="event_author")
    private String eventAuthor;
    @Column(name="event_time", nullable=false)
    private ZonedDateTime eventTime;
    @Column(name="creation_time", nullable=false, updatable=false)
    private ZonedDateTime creationTime;

    @PrePersist
    public void onCreate() {
        this.creationTime = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
    }

    @Generated
    protected MetricEventEntity(MetricEventEntityBuilder<?, ?> b) {
        super(b);
        this.metric = b.metric;
        this.resourceId = b.resourceId;
        this.eventAuthor = b.eventAuthor;
        this.eventTime = b.eventTime;
        this.creationTime = b.creationTime;
    }

    @Generated
    public static MetricEventEntityBuilder<?, ?> builder() {
        return new MetricEventEntityBuilderImpl();
    }

    @Generated
    public MetricType getMetric() {
        return this.metric;
    }

    @Generated
    public String getResourceId() {
        return this.resourceId;
    }

    @Generated
    public String getEventAuthor() {
        return this.eventAuthor;
    }

    @Generated
    public ZonedDateTime getEventTime() {
        return this.eventTime;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public void setMetric(MetricType metric) {
        this.metric = metric;
    }

    @Generated
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @Generated
    public void setEventAuthor(String eventAuthor) {
        this.eventAuthor = eventAuthor;
    }

    @Generated
    public void setEventTime(ZonedDateTime eventTime) {
        this.eventTime = eventTime;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public String toString() {
        return "MetricEventEntity(metric=" + String.valueOf(this.getMetric()) + ", resourceId=" + this.getResourceId() + ", eventAuthor=" + this.getEventAuthor() + ", eventTime=" + String.valueOf(this.getEventTime()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricEventEntity)) {
            return false;
        }
        MetricEventEntity other = (MetricEventEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetricType this$metric = this.getMetric();
        MetricType other$metric = other.getMetric();
        if (this$metric == null ? other$metric != null : !this$metric.equals(other$metric)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        String this$eventAuthor = this.getEventAuthor();
        String other$eventAuthor = other.getEventAuthor();
        if (this$eventAuthor == null ? other$eventAuthor != null : !this$eventAuthor.equals(other$eventAuthor)) {
            return false;
        }
        ZonedDateTime this$eventTime = this.getEventTime();
        ZonedDateTime other$eventTime = other.getEventTime();
        if (this$eventTime == null ? other$eventTime != null : !((Object)this$eventTime).equals(other$eventTime)) {
            return false;
        }
        ZonedDateTime this$creationTime = this.getCreationTime();
        ZonedDateTime other$creationTime = other.getCreationTime();
        return !(this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetricEventEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        MetricType $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : $metric.hashCode());
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        String $eventAuthor = this.getEventAuthor();
        result = result * 59 + ($eventAuthor == null ? 43 : $eventAuthor.hashCode());
        ZonedDateTime $eventTime = this.getEventTime();
        result = result * 59 + ($eventTime == null ? 43 : ((Object)$eventTime).hashCode());
        ZonedDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        return result;
    }

    @Generated
    public MetricEventEntity() {
    }
}

