/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.metrics.dm.api.DiagnosticsApi;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricEventRefDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricsInterestWeightsConfigurationDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.exception.MetricEventConflictException;
import com.finconsgroup.itserr.marketplace.metrics.dm.service.ConfigService;
import com.finconsgroup.itserr.marketplace.metrics.dm.service.MetricEventService;
import com.finconsgroup.itserr.marketplace.metrics.dm.service.MetricService;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class DiagnosticsController
implements DiagnosticsApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiagnosticsController.class);
    @Value(value="${log.log4j2-rolling-file-name}")
    private String log4j2RollingFileName;
    private final MetricEventService metricEventService;
    private final MetricService metricService;
    private final ConfigService configService;

    public ResponseEntity<Resource> downloadLogs() {
        log.debug("call to DiagnosticsController - downloadLogs");
        Path filePath = Paths.get(this.getLogFilePathFromLog4j2(), new String[0]);
        log.debug("Trying to retrieve log file from: {}", (Object)filePath);
        File logFile = filePath.toFile();
        if (!logFile.exists() || !logFile.isFile()) {
            throw new WP2ResourceNotFoundException("Log file not found: %s".formatted(logFile.getAbsolutePath()));
        }
        FileSystemResource resource = new FileSystemResource(logFile);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{DiagnosticsController.getContentDispositionHeaderValue((String)logFile.getName())})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
    }

    public OutputMetricEventDto createMetricEvent(MetricDtoType metric, InputCreateMetricEventDto inputCreateMetricEventDto) {
        return this.metricEventService.create(metric, inputCreateMetricEventDto);
    }

    public Page<OutputMetricEventRefDto> findAll(MetricDtoType metric, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.metricEventService.findAll(metric, (Pageable)pageable);
    }

    public OutputMetricEventDto findById(MetricDtoType metric, UUID metricEventId) {
        return this.metricEventService.findById(metric, metricEventId);
    }

    public ResponseEntity<Void> updateMetrics(boolean sync) {
        this.metricService.update(sync);
        return ResponseEntity.status((HttpStatusCode)(sync ? HttpStatus.NO_CONTENT : HttpStatus.ACCEPTED)).build();
    }

    public OutputMetricsInterestWeightsConfigurationDto getInterestWeights() {
        return this.configService.getMetricsInterestWeightsConfiguration();
    }

    public Map<String, Object> createReportMetricEvents(LocalDate fromDate, LocalDate toDate, Set<String> eventAuthorIds, int resourceCount, Set<String> resourceIds) {
        int metricsEventCount = 0;
        if (resourceCount > 0) {
            resourceIds = new HashSet<String>(resourceIds);
            IntStream.range(resourceIds.size(), resourceCount).mapToObj(i -> UUID.randomUUID().toString()).forEach(resourceIds::add);
        }
        for (String resourceId : resourceIds) {
            LocalDate eventDate = fromDate;
            while (toDate.isAfter(eventDate)) {
                for (String eventAuthorId : eventAuthorIds) {
                    for (MetricDtoType metricDtoType : MetricDtoType.values()) {
                        try {
                            this.metricEventService.create(metricDtoType, InputCreateMetricEventDto.builder().eventTime(ZonedDateTime.of(eventDate, LocalTime.now(), ZoneId.of("UTC"))).resourceId(resourceId).eventAuthor(eventAuthorId).build());
                            ++metricsEventCount;
                        }
                        catch (MetricEventConflictException e) {
                            log.debug("Metric event already exists for the combination");
                        }
                    }
                }
                eventDate = eventDate.plusDays(1L);
            }
        }
        return Map.of("count", metricsEventCount);
    }

    private String getLogFilePathFromLog4j2() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        RollingFileAppender appender = (RollingFileAppender)context.getConfiguration().getAppender(this.log4j2RollingFileName);
        return appender.getFileName();
    }

    private static String getContentDispositionHeaderValue(String fileName) {
        return "attachment; filename=\"%s\"".formatted(fileName);
    }

    @Generated
    public DiagnosticsController(MetricEventService metricEventService, MetricService metricService, ConfigService configService) {
        this.metricEventService = metricEventService;
        this.metricService = metricService;
        this.configService = configService;
    }
}

