package com.finconsgroup.itserr.marketplace.metrics.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.time.LocalDate;

/**
 * Input DTO for finding a metrics data to be displayed on the dashboards.
 */
@Schema(name = "InputFindDashboardMetricsDto",
        description = "DTO for finding a metrics data to be displayed on the dashboards")
@Data
@Builder
@AllArgsConstructor
public class InputFindDashboardMetricsDto {

    @Schema(description = "The time resolution to aggregate for", example = "DAILY")
    @NotNull
    private MetricTimeResolution timeResolution;

    @Schema(description = "The date from which events should be considered", example = "2025-08-01")
    private LocalDate fromDate;

    @Schema(description = "The date until which events should be considered", example = "2025-08-31")
    @NotNull
    private LocalDate toDate;
}
