/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.mapper;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricEventRefDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricEventBeneficiaryEntity;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricEventEntity;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricType;
import com.finconsgroup.itserr.marketplace.metrics.dm.mapper.BeneficiaryMapper;
import com.finconsgroup.itserr.marketplace.metrics.dm.mapper.MetricEventMapper;
import com.finconsgroup.itserr.marketplace.metrics.dm.mapper.MetricEventMapperImpl;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetricEventMapperImpl
implements MetricEventMapper {
    @Autowired
    private BeneficiaryMapper beneficiaryMapper;

    public MetricEventEntity toEntity(MetricDtoType metric, InputCreateMetricEventDto model) {
        if (metric == null && model == null) {
            return null;
        }
        MetricEventEntity.MetricEventEntityBuilder metricEventEntity = MetricEventEntity.builder();
        if (model != null) {
            metricEventEntity.resourceId(model.getResourceId());
            metricEventEntity.eventAuthor(model.getEventAuthor());
            metricEventEntity.eventTime(model.getEventTime());
        }
        metricEventEntity.metric(this.metricDtoTypeToMetricType1(metric));
        return metricEventEntity.build();
    }

    public OutputMetricEventDto toDto(MetricEventEntity entity, Collection<MetricEventBeneficiaryEntity> beneficiaries) {
        if (entity == null && beneficiaries == null) {
            return null;
        }
        OutputMetricEventDto.OutputMetricEventDtoBuilder outputMetricEventDto = OutputMetricEventDto.builder();
        if (entity != null) {
            outputMetricEventDto.id(entity.getId());
            outputMetricEventDto.metric(this.metricTypeToMetricDtoType1(entity.getMetric()));
            outputMetricEventDto.resourceId(entity.getResourceId());
            outputMetricEventDto.eventAuthor(entity.getEventAuthor());
            outputMetricEventDto.eventTime(entity.getEventTime());
            outputMetricEventDto.creationTime(entity.getCreationTime());
        }
        outputMetricEventDto.beneficiaries(this.beneficiaryMapper.toDtoList(beneficiaries));
        return outputMetricEventDto.build();
    }

    public OutputMetricEventRefDto toRefDto(MetricEventEntity entity) {
        if (entity == null) {
            return null;
        }
        OutputMetricEventRefDto.OutputMetricEventRefDtoBuilder outputMetricEventRefDto = OutputMetricEventRefDto.builder();
        outputMetricEventRefDto.id(entity.getId());
        outputMetricEventRefDto.metric(this.metricTypeToMetricDtoType1(entity.getMetric()));
        outputMetricEventRefDto.resourceId(entity.getResourceId());
        outputMetricEventRefDto.eventAuthor(entity.getEventAuthor());
        outputMetricEventRefDto.eventTime(entity.getEventTime());
        outputMetricEventRefDto.creationTime(entity.getCreationTime());
        return outputMetricEventRefDto.build();
    }

    protected MetricType metricDtoTypeToMetricType1(MetricDtoType metricDtoType) {
        if (metricDtoType == null) {
            return null;
        }
        return switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$metrics$dm$dto$MetricDtoType[metricDtoType.ordinal()]) {
            case 1 -> MetricType.CATALOG_ITEM_DOWNLOAD;
            case 2 -> MetricType.CATALOG_ITEM_VIEW;
            case 3 -> MetricType.CATALOG_ITEM_FAVOURITE;
            case 4 -> MetricType.CATALOG_ITEM_COMMENT;
            case 5 -> MetricType.CATALOG_ITEM_UNFAVOURITE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(metricDtoType));
        };
    }

    protected MetricDtoType metricTypeToMetricDtoType1(MetricType metricType) {
        if (metricType == null) {
            return null;
        }
        return switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$metrics$dm$entity$MetricType[metricType.ordinal()]) {
            case 1 -> MetricDtoType.CATALOG_ITEM_DOWNLOAD;
            case 2 -> MetricDtoType.CATALOG_ITEM_VIEW;
            case 3 -> MetricDtoType.CATALOG_ITEM_FAVOURITE;
            case 4 -> MetricDtoType.CATALOG_ITEM_COMMENT;
            case 5 -> MetricDtoType.CATALOG_ITEM_UNFAVOURITE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(metricType));
        };
    }
}

