/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputDashboardMetricsDto;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDate;
import java.util.Map;
import lombok.Generated;

@Schema(name="OutputDashboardMetricsDto", description="DTO representing a aggregated metric events for dashboard in responses")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OutputDashboardMetricsDto {
    @Schema(description="The day of the event", example="2026-01-01")
    private LocalDate eventDay;
    @Schema(description="The year of the event. May not be always populated.", example="2026")
    private Integer eventYear;
    @Schema(description="The month of the event 1-based, e.g. 1 for January. May not be always populated.", example="1")
    private Integer eventMonth;
    @Schema(description="The quarter of the event 1-based, e.g. 1 for Jan-Mar. May not be always populated.", example="1")
    private Integer eventQuarter;
    @Schema(description="The number of resources.", example="15")
    private Long resources;
    @Schema(description="The map of metrics and corresponding values", example="{\"catalog-item-download\": 12, \"catalog-item-view\": 10, \"catalog-item-favourite\": 15, \"catalog-item-comment\": 18 }")
    private Map<MetricDtoType, Double> metrics;

    @Generated
    protected OutputDashboardMetricsDto(OutputDashboardMetricsDtoBuilder<?, ?> b) {
        this.eventDay = b.eventDay;
        this.eventYear = b.eventYear;
        this.eventMonth = b.eventMonth;
        this.eventQuarter = b.eventQuarter;
        this.resources = b.resources;
        this.metrics = b.metrics;
    }

    @Generated
    public static OutputDashboardMetricsDtoBuilder<?, ?> builder() {
        return new OutputDashboardMetricsDtoBuilderImpl();
    }

    @Generated
    public LocalDate getEventDay() {
        return this.eventDay;
    }

    @Generated
    public Integer getEventYear() {
        return this.eventYear;
    }

    @Generated
    public Integer getEventMonth() {
        return this.eventMonth;
    }

    @Generated
    public Integer getEventQuarter() {
        return this.eventQuarter;
    }

    @Generated
    public Long getResources() {
        return this.resources;
    }

    @Generated
    public Map<MetricDtoType, Double> getMetrics() {
        return this.metrics;
    }

    @Generated
    public void setEventDay(LocalDate eventDay) {
        this.eventDay = eventDay;
    }

    @Generated
    public void setEventYear(Integer eventYear) {
        this.eventYear = eventYear;
    }

    @Generated
    public void setEventMonth(Integer eventMonth) {
        this.eventMonth = eventMonth;
    }

    @Generated
    public void setEventQuarter(Integer eventQuarter) {
        this.eventQuarter = eventQuarter;
    }

    @Generated
    public void setResources(Long resources) {
        this.resources = resources;
    }

    @Generated
    public void setMetrics(Map<MetricDtoType, Double> metrics) {
        this.metrics = metrics;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputDashboardMetricsDto)) {
            return false;
        }
        OutputDashboardMetricsDto other = (OutputDashboardMetricsDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$eventYear = this.getEventYear();
        Integer other$eventYear = other.getEventYear();
        if (this$eventYear == null ? other$eventYear != null : !((Object)this$eventYear).equals(other$eventYear)) {
            return false;
        }
        Integer this$eventMonth = this.getEventMonth();
        Integer other$eventMonth = other.getEventMonth();
        if (this$eventMonth == null ? other$eventMonth != null : !((Object)this$eventMonth).equals(other$eventMonth)) {
            return false;
        }
        Integer this$eventQuarter = this.getEventQuarter();
        Integer other$eventQuarter = other.getEventQuarter();
        if (this$eventQuarter == null ? other$eventQuarter != null : !((Object)this$eventQuarter).equals(other$eventQuarter)) {
            return false;
        }
        Long this$resources = this.getResources();
        Long other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        LocalDate this$eventDay = this.getEventDay();
        LocalDate other$eventDay = other.getEventDay();
        if (this$eventDay == null ? other$eventDay != null : !((Object)this$eventDay).equals(other$eventDay)) {
            return false;
        }
        Map this$metrics = this.getMetrics();
        Map other$metrics = other.getMetrics();
        return !(this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutputDashboardMetricsDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $eventYear = this.getEventYear();
        result = result * 59 + ($eventYear == null ? 43 : ((Object)$eventYear).hashCode());
        Integer $eventMonth = this.getEventMonth();
        result = result * 59 + ($eventMonth == null ? 43 : ((Object)$eventMonth).hashCode());
        Integer $eventQuarter = this.getEventQuarter();
        result = result * 59 + ($eventQuarter == null ? 43 : ((Object)$eventQuarter).hashCode());
        Long $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        LocalDate $eventDay = this.getEventDay();
        result = result * 59 + ($eventDay == null ? 43 : ((Object)$eventDay).hashCode());
        Map $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OutputDashboardMetricsDto(eventDay=" + String.valueOf(this.getEventDay()) + ", eventYear=" + this.getEventYear() + ", eventMonth=" + this.getEventMonth() + ", eventQuarter=" + this.getEventQuarter() + ", resources=" + this.getResources() + ", metrics=" + String.valueOf(this.getMetrics()) + ")";
    }

    @Generated
    public OutputDashboardMetricsDto() {
    }

    @Generated
    public OutputDashboardMetricsDto(LocalDate eventDay, Integer eventYear, Integer eventMonth, Integer eventQuarter, Long resources, Map<MetricDtoType, Double> metrics) {
        this.eventDay = eventDay;
        this.eventYear = eventYear;
        this.eventMonth = eventMonth;
        this.eventQuarter = eventQuarter;
        this.resources = resources;
        this.metrics = metrics;
    }
}

