/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.api;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.InputFindDashboardMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputDashboardMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputReportMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourcesDailyMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourcesSummaryMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.ReportGranularity;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.List;
import java.util.Set;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Metric", description="The Metric API: it provides endpoints for managing metrics")
@SecurityRequirement(name="BearerAuth")
public interface MetricApi {
    @Operation(summary="Find resources daily metrics for a dates range", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/metrics/resources/{resourcesIds}/metrics/{fromDate}/{toDate}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputResourcesDailyMetricsDto findResourcesDailyMetrics(@Schema(example="f47ac10b-58cc-4372-a567-0e02b2c3d479") @PathVariable(value="resourcesIds") Set<String> var1, @Schema(example="2025-08-08") @PathVariable(value="fromDate") LocalDate var2, @Schema(example="2025-08-10") @PathVariable(value="toDate") LocalDate var3);

    @Operation(summary="Summarize the total metrics of the given resources (summed together)", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/metrics/metrics-summaries"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputResourcesSummaryMetricsDto findResourcesSummaryMetrics(@RequestParam(value="resourceId") @NotEmpty Set<String> var1, @RequestParam(value="toDate", required=false) LocalDate var2);

    @Operation(summary="Summarize the total metrics of the given resources (summed together) aggregated by resource id", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/metrics/report/metrics-summaries"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<OutputReportMetricsDto> findReportingMetrics(@Schema(example="f47ac10b-58cc-4372-a567-0e02b2c3d479") @RequestParam(value="resourceId") @NotEmpty Set<String> var1, @Schema(example="USER") @RequestParam(value="granularity") @NotNull ReportGranularity var2, @Schema(example="2025-08-08") @RequestParam(value="fromDate", required=false) LocalDate var3, @Schema(example="2025-08-10") @RequestParam(value="toDate", required=false) LocalDate var4);

    @Operation(summary="Summarize the total metrics across all resources (summed together) aggregated based on the input", responses={@ApiResponse(responseCode="200", description="OK")})
    @PostMapping(value={"/metrics/dashboard/metrics-summaries"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<List<OutputDashboardMetricsDto>> findDashboardMetrics(@RequestBody @Valid List<InputFindDashboardMetricsDto> var1);
}

