package com.finconsgroup.itserr.marketplace.metrics.dm.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;

import java.util.UUID;

/**
 * Exception thrown when a metric event cannot be found in the system.
 */
public class MetricEventNotFoundException extends WP2ResourceNotFoundException {

    /** Message template for metric event not found exceptions */
    public static final String METRIC_EVENT_NOT_FOUND_EXCEPTION_MESSAGE = "metricEvent with id: '%s' not found";

    /**
     * Constructs a new MetricEventNotFoundException with the specified ID.
     *
     * @param id the UUID of the metric event that was not found
     */
    public MetricEventNotFoundException(UUID id) {
        super(METRIC_EVENT_NOT_FOUND_EXCEPTION_MESSAGE.formatted(id.toString()));
    }

}
